-- vols.sql (SQLite)
PRAGMA foreign_keys = OFF;

BEGIN TRANSACTION;

DROP TABLE IF EXISTS avion;
DROP TABLE IF EXISTS pilote;
DROP TABLE IF EXISTS vol;

CREATE TABLE avion (
  avion_id     INTEGER NOT NULL,
  avion_type   TEXT,
  avion_cap    INTEGER,
  avion_loc    TEXT,
  avion_status TEXT,
  PRIMARY KEY (avion_id)
);

CREATE TABLE pilote (
  pilote_id         INTEGER NOT NULL,
  pilote_name       TEXT,
  pilote_birthdate  TEXT,   -- dates au format 'YYYY-MM-DD'
  pilote_address    TEXT,
  pilote_telephone  TEXT,
  pilote_salary     REAL,
  PRIMARY KEY (pilote_id)
);

CREATE TABLE vol (
  vol_id          INTEGER NOT NULL,
  vol_pilote_id   INTEGER NOT NULL,
  vol_avion_id    INTEGER NOT NULL,
  vol_villeDepart TEXT,
  vol_villeArrive TEXT,
  vol_heureDepart TEXT,     -- heures au format 'HH:MM:SS'
  vol_heureArrive TEXT,
  vol_date        TEXT,     -- dates au format 'YYYY-MM-DD'
  PRIMARY KEY (vol_id)
  -- Si tu veux des clés étrangères, décommente ci-dessous :
  -- ,FOREIGN KEY (vol_pilote_id) REFERENCES pilote(pilote_id)
  -- ,FOREIGN KEY (vol_avion_id)  REFERENCES avion(avion_id)
);

INSERT INTO avion (avion_id, avion_type, avion_cap, avion_loc, avion_status) VALUES
(1,  'A300',     300, 'Nice',     'En service'),
(2,  'A300',     300, 'Nice',     'En service'),
(3,  'A320',     320, 'Paris',    'En service'),
(4,  'A300',     300, 'Paris',    'En service'),
(5,  'CONCORDE', 300, 'Nice',     'En service'),
(6,  'B707',     400, 'Paris',    'En panne'),
(7,  'CARAVELLE',300, 'Paris',    'En service'),
(8,  'B727',     250, 'Toulouse', 'En service'),
(9,  'CONCORDE', 350, 'Toulouse', 'En service'),
(10, 'A300',     400, 'Paris',    'En service'),
(11, 'A300',     400, 'Paris',    'En service'),
(12, 'A300',     400, 'Paris',    'En service');

INSERT INTO vol (vol_id, vol_pilote_id, vol_avion_id, vol_villeDepart, vol_villeArrive, vol_heureDepart, vol_heureArrive, vol_date) VALUES
(100, 1,  1,  'Nice',     'Paris',     '06:13:45', '11:15:00', '1989-10-03'),
(110, 3,  6,  'Nice',     'Toulouse',  '13:40:30', '15:23:37', '1989-10-06'),
(111, 5,  3,  'Nice',     'Paris',     '05:08:00', '10:09:20', '1989-10-04'),
(120, 4,  3,  'Nice',     'Paris',     '08:20:20', '11:19:13', '1989-10-21'),
(125, 12, 6,  'Paris',    'Nice',      '13:40:32', '14:18:45', '1989-10-10'),
(130, 4,  8,  'Toulouse', 'Beauvais',  '19:40:30', '23:27:50', '1989-10-27'),
(135, 8,  5,  'Paris',    'Toulouse',  '13:12:00', '14:13:20', '1989-10-22'),
(140, 14, 9,  'Lyon',     'Nice',      '05:07:00', '06:07:50', '1989-10-04'),
(150, 1,  1,  'Paris',    'Nantes',    '19:16:30', '23:17:25', '1989-10-28'),
(153, 2,  3,  'Lyon',     'Nice',      '04:17:25', '07:13:00', '1989-10-06'),
(156, 9,  2,  'Paris',    'Lyon',      '14:02:30', '16:03:20', '1989-10-14'),
(200, 5,  3,  'Nice',     'Toulouse',  '05:20:30', '06:21:25', '1989-10-17'),
(210, 14, 7,  'Nice',     'Nantes',    '08:14:30', '10:15:25', '1989-10-14'),
(236, 8,  4,  'Lyon',     'Toulouse',  '14:21:30', '16:22:50', '1989-10-15'),
(240, 13, 10, 'Nice',     'Paris',     '11:23:00', '12:23:55', '1989-10-19'),
(250, 13, 4,  'Bordeaux', 'Paris',     '11:23:00', '12:23:55', '1989-10-25'),
(260, 13, 5,  'Bordeaux', 'Paris',     '09:23:00', '15:23:55', '1989-10-30'),
(270, 13, 9,  'Paris',    'New york',  '00:14:00', '03:23:00', '1989-10-03'),
(280, 8,  9,  'Nice',     'Mulhouse',  '00:12:00', '02:13:20', '1989-10-21'),
(290, 3,  8,  'Beauvais', 'Marseille', '11:12:30', '14:14:25', '1989-10-09'),
(310, 19, 8,  'Beauvais', 'Marseille', '20:12:30', '21:14:25', '1989-10-09');

INSERT INTO pilote (pilote_id, pilote_name, pilote_birthdate, pilote_address, pilote_telephone, pilote_salary) VALUES
(1,  'Miranda',    '1952-10-16', 'Sophia-Antipolis', '93548254', 18009),
(2,  'St-exupery', '1932-10-16', 'Lyon',             '91548254', 12300),
(3,  'Armstrong ', '1930-10-11', 'Wapakoneta',       '96548254', 24500),
(4,  'Tintin',     '1929-10-01', 'Bruxelles',        '93548254', 21100),
(5,  'Gagarine',   '1934-10-12', 'Klouchino',        '93548454', 22100),
(6,  'Baudry',     '1959-10-31', 'Toulouse',         '93548444', 21000),
(8,  'Bush',       '1924-10-28', 'Milton',           '44556254', 22000),
(9,  'Ruskoi',     '1930-10-16', 'Moscou',           '73548254', 22000),
(10, 'Math',       '1938-10-12', 'Paris',            '23548254', 15000),
(11, 'Yen',        '1942-10-19', 'Munich',           '13548254', 29000),
(12, 'Icare',      '1962-10-17', 'Ithaques',         '73548211', 17000.6),
(13, 'Mopolo',     '1955-10-04', 'Nice',             '93958211', 17000.6),
(14, 'Chretien',   '1945-10-04', '',                 '73223322', 15000.6),
(15, 'Vernes',     '1935-10-04', 'Paris',            '',         17000.6),
(16, 'Tournesol',  '1929-10-04', 'Bruxelles',        '666666',   15000.6),
(17, 'Concorde',   '1966-10-04', 'Paris',            '777777',   21000.6),
(18, 'Foudil',     '1966-10-04', 'Paris',            '1111111',  21000.6),
(19, 'Foudelle',   '1966-10-04', 'Paris',            '2222222',  21000.6),
(20, 'Zembla',     '1966-10-04', 'Paris',            '3333333',  21000.6);

COMMIT;

PRAGMA foreign_keys = ON;
