#!/usr/bin/env python
# coding: utf-8

# In[1]:


def initialisation(nom_joueur1, nom_joueur2):
    jeu = {}
    jeu['joueur1'] = nom_joueur1          # Nom du premier joueur
    jeu['joueur2'] = nom_joueur2          # Nom du second joueur
    jeu['score'] = [0, 0]                 # Réserve du joueur 1 puis du joueur 2
    jeu['n'] = 0                          # Nombre de tours déjà effectués
    jeu['plateau'] = [4] * 12             # Plateau de jeu initial (p4)
    return jeu


# In[2]:


def tour_joueur1(jeu):
    return jeu['n'] % 2 ==0


# In[3]:


def tourner_plateau(jeu):
    jeu['plateau'] = jeu['plateau'][6:] + jeu['plateau'][:6]


# In[4]:


#q5
def copie(jeu):
    cop = {}
    cop['joueur1'] = jeu['joueur1']     # str, immuable
    cop['joueur2'] = jeu['joueur2']     # str, immuable
    cop['score'] = jeu['score'][:]      # copie de liste
    cop['n'] = jeu['n']                  # int, immuable
    cop['plateau'] = jeu['plateau'][:]  # copie de liste
    return cop


# In[5]:


#q6
def deplacer_graine(plateau,case):
    if plateau[case] == 0: 
        return
    def aux(c,nb):
        if nb == 0:
            return (c-1) % len(plateau)
        if c == case:#pas de graine dans la case d'où on est parti
            return aux ((c+1) % len(plateau),nb)
        plateau[c] = plateau[c]+1
        return aux ((c+1) % len(plateau),nb-1)
    n = plateau[case]
    plateau[case] = 0
    return aux((case+1) % len(plateau),n)



def case_ramassable(plateau, case):
    return case >= len(plateau) // 2 \
        and 1 < plateau[case] <= 3

def ramasser_graines(plateau,case):
    g=0
    while case_ramassable(plateau,case):
        g += plateau[case]
        plateau[case]=0
        case -= 1
    return g


def absence_famine(plateau, case):
    plateau_cp = plateau[:]
    i = deplacer_graine(plateau_cp,case)
    return sum(plateau_cp[len(plateau_cp)//2:])\
                != 0



def test_case(plateau, case):
    return 0 <= case < len(plateau)//2\
        and plateau[case]>0\
        and absence_famine(plateau, case)

def cases_possibles(jeu:dict):
    return [i for i in range(len(jeu["plateau"])//2) if test_case(jeu["plateau"],i)]

def cases_possibles(jeu:dict):
    res = []
    for i in range(len(jeu["plateau"])//2):
        if test_case(jeu["plateau"],i):
            res.append(i)
    return res


def tour_suivant(jeu):
    if max(jeu['score'])>24:
        return False
    if sum(jeu['plateau'])<4:
        return False
    if jeu['n'] >=100:
        return False
    if len(cases_possibles(jeu)) == 0:
        return False
    return True


def tour_jeu(jeu,case):
    i = deplacer_graine(jeu["plateau"],case)
    plateau_cp=jeu['plateau'][:]
    g = ramasser_graines(plateau_cp,i)
    if sum(plateau_cp[len(plateau_cp)//2:]) != 0:
        jeu["plateau"] = plateau_cp
    else: g=0 #annulation du gain car famine
    if tour_joueur1(jeu): jeu['score'][0] += g
    else: jeu['score'][1] += g
    jeu['n']+=1
    tourner_plateau(jeu)
    return tour_suivant(jeu)
        

def gagnant(jeu):
    assert not tour_suivant(jeu)
    plateau=jeu['plateau']
    if tour_joueur1(jeu):
        jeu['score'][0] += sum(plateau[:len(plateau)//2])
        jeu['score'][1] += sum(plateau[len(plateau)//2:])
    else:
        jeu['score'][1] += sum(plateau[:len(plateau)//2])
        jeu['score'][0] += sum(plateau[len(plateau)//2:])
    if jeu['score'][0] > jeu['score'][1]:
        return jeu['joueur1']
    if jeu['score'][0] < jeu['score'][1]:
        return jeu['joueur2']
    return "égalité"

    
def configurations(total,N):
    res = []
    def aux (pos, subtotal, acc):
        if pos == N - 1:
            res.append(acc + [subtotal])
            return
        for s in range(subtotal+1):
            aux(pos+1,subtotal-s,acc+[s])
    aux(0,total,[])
    return res


            

def gain(jeu:dict, case:int) -> tuple[int,dict]:
    #la case est SUPPOSEE valide !
    jeu_cp = copie(jeu)
    tour_jeu(jeu_cp, case)#jeu_cp est modifié
    if tour_joueur1(jeu):
        g = jeu_cp['score'][0] - jeu['score'][0]
    else:
        g = jeu_cp['score'][1] - jeu['score'][1]
    return g, jeu_cp



def NegaAwale(jeu, profondeur_max, profondeur):
    if not tour_suivant(jeu):  # Condition 1 : état terminal
        if (tour_joueur1(jeu) and gagnant(jeu) == jeu['joueur1']) or \
           (not tour_joueur1(jeu) and gagnant(jeu) == jeu['joueur2']):
            return 500

        elif (tour_joueur1(jeu) and gagnant(jeu) == jeu['joueur2']) or \
             (not tour_joueur1(jeu) and gagnant(jeu) == jeu['joueur1']):
            return -500

        else:  # Égalité
            return 0

    elif profondeur == profondeur_max:  # Condition 2 : profondeur max atteinte
        return 0

    else: # tour normal
        choix_cases = cases_possibles(jeu)
        vals_jeu = []
        for case in choix_cases:
            # Instruction 1 : Détermination du gain g et du nouveau jeu
            g, jeu_case = gain(jeu,case)
            # Instruction 2 : Remontée de la valeur de jeu du noeud enfant
            p = NegaAwale(jeu_case,profondeur_max,profondeur + 1)
            vals_jeu.append([case, g - p])

        return max_vals(vals_jeu, profondeur)


# In[42]:


def max_vals(vals_jeu:list, profondeur:int) -> int:
    c, mVJ  = vals_jeu[0]
    for i in range(1,len(vals_jeu)):
        if mVJ < vals_jeu[i][1]:
            mVJ,c = vals_jeu[i][1], i
    if profondeur == 0:#racine de l'arbre
        return c #meilleure case à jouer dans la situation qui a conduit à vals_jeu
    return mVJ


# In[ ]:


def awale_jcj(nom_joueur1, nom_joueur2):
    jeu = initialisation(nom_joueur1, nom_joueur2)
    jeu_continue = True
    while jeu_continue:
        affiche(jeu['plateau'])
        case_choisie = NegaAwale(jeu,6,0)
        # l'IA regarde quelle est la meilleure case 
        jeu_continue = tour_jeu(jeu, case_choisie)
    return gagnant(jeu)  


# Avce ce choix d'implémentation on n'a qu'une IA qui joue contre elle-même.
# Alternativement, elle représente le joueur 1 ou le joueur 2 sans changer de stratégie.
# 
# 
# On pourrait pimenter les choses en imposant une stratégie différente selon que c'est le joueur 1 qui joue ou le joueur 2. Par exemple
# prendre `if VJ < vals_jeu[i]` (choix de la première meilleure case) pour le 1er joueur dans `max_vals` et `if VJ <= vals_jeu[i]` (choix de la dernière meilleure case)
# 
# 

