#Simple minmax avec exploration exhaustive
def minmax(j:Player,e: tuple[Player, int])->int:
    l = move(e)
    if l == []: #état terminal
        if player(e)==other(j):
            return 1 #j gagne
        else:
            return -1
    #noeud interne
    if player(e) == j:
        analyse=max #on veut maximiser les gains
    else:
        analyse=min #on veut minimiser les pertes
    return analyse([minmax(j,v) for v in l])

#minmax avec heuristique et profondeur max.
def minmax_h(j,e,h,p):
    l = move(e)  # successeurs de e
    if l == []:
        if player(e) == other(j):
            return 1000   # j vient de gagner
        else:
            return -1000  # j vient de perdre
    if p == 0:
        val = h(e)
        if player(e) == j:
            return val      # bon pour j
        else:
            return -val     # bon pour l'adversaire
    valeurs = [minmax_h(j, e2, h, p-1) for e2 in l]
    if player(e) == j:
        return max(valeurs)   # j cherche à maximiser
    else:
        return min(valeurs)   # l'autre cherche à minimiser
        
