#!/usr/bin/env python
# coding: utf-8

#graphe 1
ex1 = [[(1,1),(2,3)],[(0,1),(2,1),(3,2)],[(0,3),(1,1),(4,4)],\
[(1,2),(4,2),(5,6)],[(2,4),(3,2),(5,2)],[(3,6),(4,2)]]


# On lit que $(0,2)$ est un arc et que son poids est 2, que $(3,5)$ est un autre arc et son poids est 6 etc.

#graphe 2
ex2 = [[(1,6),(2,9)],[(0,6),(2,5),(3,8),(6,6)],[(0,9),(1,5),(3,4),(4,8),(5,7)],\
[(1,8),(2,4),(5,4),(6,5)],[(2,8),(5,9),(7,4)],[(2,7),(3,4),(4,9),(6,3),(7,10)],\
[(1,6),(3,5),(5,3),(7,6)],[(4,4),(5,10),(6,6)]]


# un graphe vu en cours
cours = [[(1,12),(4,5)],[(2,2)],[(0,1)],\
         [(2,2),(1,3)],[(1,1),(3,2),(2,4)]]


# Les dessiner.

import heapq as hq #importer le module

def dijkstrafp(g , s ) :
    n = len ( g )
    visite = [False] * n
    dist = [None] * n
    filep = []
    hq.heappush (filep, (0, s))
    while len ( filep ) != 0:
        delta , x = hq.heappop ( filep )
        if not visite [x]:
            visite [x] = True # x devient rouge
            dist[x]=delta
            for y,w in g [ x ]:
                hq.heappush(filep,(delta+w,y))   
    return dist


def dijkstrafp2(g , s ) :
    n = len ( g )
    visite = [False] * n
    dist = [None] * n
    pred = [None] * n
    filep = []
    hq.heappush (filep, (0, s, s))
    while len ( filep ) != 0:
        delta , x, pere = hq.heappop ( filep )
        if not visite [x]:
            visite [x] = True # x devient rouge
            dist[x]=delta
            pred[x] = pere
            for y,w in g [ x ]:
                hq.heappush(filep,(delta+w,y,x))   
    return dist,pred


def chemin(s,b,peres):
    u=peres[b]
    c = [b]
    while u!=None and u!=s:
        c.append(u)
        u=peres[u]
    if u==s:
        c.append(s)
        c.reverse()
        return c
    raise Exception

def chemin(s,b,peres):
    if b==s:
        return [s]
    if b is None:
        raise Exception
    ch = chemin(s,peres[b], peres)
    ch.append(b)
    return ch

    
cours = [[(1,12),(4,5)],[(2,2)],[(0,1)],\
         [(2,2),(1,3)],[(1,1),(3,2),(2,4)]]


#***************
def voisins (mase, case):
    i,j=case
    if maze[i][j]==0:
        return []
    v = []
    n = len(maze)
    if i>0 and maze[i-1][j]==1:
        v.append(((i-1,j),1))
    if i<n-1 and maze[i+1][j]==1:
        v.append(((i+1,j),1))
    if j>0 and maze[i][j-1]==1:
        v.append(((i,j-1),1))
    if j<n-1 and maze[i][j+1]==1:
        v.append(((i,j+1),1))
    return v
                


# In[18]:


voisins(maze,(0,1)), voisins(maze,(6,4)),voisins(maze,(6,0))


# ### Q2
# 
# 

# 
# L'origine du nom de la *distance Manhattan* (ou distance de taxi) vient de la structure en quadrillage régulier des rues du quartier de Manhattan (New York). 
# 
# C'est la distance entre deux points dans un environnement basé sur une grille (avec uniquement des mouvements horizontaux et verticaux). 
# 
# La distance de Manhattan est la simple somme des mouvements horizontaux et verticaux, alors que la distance diagonale ou "à vol d'oiseau" peut être calculée en appliquant le théorème de Pythagore. 
# 

# ```python
# #***********
# import matplotlib.pyplot as plt
# 
# fig,ax = plt.subplots()
# s1 = plt.scatter(1,1,s=50)
# s2 =  plt.scatter(4,3,s=50)
# plt.plot([1,4],[1,3],label="distance euclidienne")
# 
# plt.plot([1,1,4],[1,3,3], linestyle="dashed",label="Manhattan(1)")
# plt.plot([1,2.5,2.5,3.5,3.5,4,4],[1,1,1.5,1.5,2.5,2.5,3], linestyle="dashed",label="Manhattan(2)")
# plt.title("Distance de Manhattan VS distance euclidienne")
# 
# ax.grid()
# ax.axis("equal")
# plt.legend()
# plt.savefig("manhattan.png")
# 
# plt.show()
# #*******************
# ```

# Une figure avec deux façons différentes de calculer la distance de Manhattan :
# 
# ![Manhattan](manhattan.png)

# 1. Ecrire la fonction `manhattan(c1,c2)` qui calcule la distance de Manhattan entre deux cases `c1,c2` données comme des tuples de coordonnées.

# In[19]:


#************
def manhattan(c1,c2):
    x1,y1=c1
    x2,y2=c2
    return abs(x1-x2)+abs(y1-y2)


# In[20]:


manhattan((3,4),((7,2)))


# 2. Implémenter la fonction `heur(b)` qui prend en paramètre un sommet donné $b$ (le *but*) et retourne une fonction qui calcule la distance de Manhatan entre son argument et le but. Donc `heur(b)` renvoie la fonction :
# $$
# h:x\mapsto \text{distance de Manhattan de $x$ à $b$}.$$ 
# 

# In[21]:


#***********
def heur(b):
    return lambda c: manhattan(c,b)


# In[22]:


h=heur((3,4))
h((7,2)), h((0,0))


# ### 

# ### Q3
# 
# Ecrire la fonction `astar(g , s , b ,h) ` qui prend en paramètre un graphe pondéré dont les sommets sont des tuples $(i,j)$, une source, un but et une heuristique. La fonction calcule un plus court chemin entre $s$ et $b$ selon l'algorithme A* et renvoie deux dictionnaires :
# 
# - le premier associe à un tuples $(i,j)$ sa distance à la source;
# 
# - le second associe au même tuples $(i,j)$ son prédecesseur dans un plus court chemin depuis la source.
# 
# Notons qu'il peut y avoir des cases non reneignées puisque A* ne passe que par des sommets jugés à un moment utiles dans un chemin de la source au but.

# In[23]:


#***************

def astar(g , s , b ,h) :
    n = len ( g )
    dist = {(i,j) : None for j in range (n) for i in range(n)}
    pere = {(i,j) : None for j in range (n) for i in range(n)}
    dist[s]=0
    pere[s]=s
    filep = []
    hq.heappush (filep, (h(s), s))
    while len ( filep ) != 0:
        score , x = hq.heappop ( filep )
        if x==b: return dist,pere
        for v , w in voisins(g, x):
            #à priori w vaut 1 mais ça peut changer
            candidat_distance = dist[x] + w
            if dist[v] is None or candidat_distance < dist[v]: 
                hq.heappush(filep,(candidat_distance+h(v),v))
                dist[v]=candidat_distance
                pere[v]=x
    return dist,pere


# In[24]:


s = (0,0)
b = (8,8)
h = heur(b)
distance, parent = astar(maze,s,b,h) 
distance[b], parent[b]


# In[25]:


distance[(8,0)]


# In[26]:


path = chemin(s,b,parent)
for e in path:
    print(e,end= ", ")


# In[27]:


len(path) # correct


# On voit bien que le parcours n'aborde que les sommest "utiles", beaucoup sont laissés de côté !

# In[28]:


len([k for k in distance if distance[k] is None and maze[k[0]][k[1]]==1])
