#!/usr/bin/env python
# coding: utf-8

# In[36]:


import jupyterlab
jupyterlab.__version__


# # Présentation
# 
# On implémente ici les notions d'*attracteur* et de recherche *min-max* adaptés au problème du jeu de Nim (ou jeu des allumenttes).
# 
# Dans ce jeu à 2 joueurs, la configuration initiale est un tas d'allumettes. Chaque joueur retire entre 1 et $n$ allumettes du tas. Le gagnant  est celui qui retire la dernière allumette. Vu autrement, le joueur qui doit jouer alors que le tas est vide a perdu.
# 
# 
# 
# 

# In[1]:


#******************
#consulter : 
#https://www.informatique-mpi.fr/files/code/game.ml.html


# On définit la variable globale `N` : elle indique le nombre maximum d'allumettes qu'on peut retirer du tas:

# In[2]:


N=3


# La variable globale `init` indique le contenu initial du tas.

# In[3]:

init=17#taille initiale


# Les codes qui suivent se réfèrent tous à ces quantités. Si on veut changer le nombre d'allumettes initial ou ramassable, changer les valeurs globales puis tout recompiler !

# # Outils

# On utilise les énumérations python. On crée d'abord un type `Player` :

# In[4]:


from enum import Enum

class Player(Enum):
    one=1
    two=2

J1=Player.one
J2=Player.two
type (J1), J1.value, J1.name


# In[5]:


J1 is Player.one


# **Les états sont des tuples (joueur, nombre d'allumettes).**

# ### Q1
# 
# Ecrire la fonction `other(p)` qui prend en paramètre un joueur et renvoie l'autre joueur.

# In[6]:


#****************
def other(p: Player) -> Player:
    return Player.two \
        if p == Player.one\
    else Player.one


# In[7]:


other(Player.one)


# ### Q2
# Ecrire la fonction `player(e: tuple[Player, int])->Player` qui renvoie le joueur auquel appartient l'état. 

# In[8]:


#***************
def player(e: tuple[Player, int])->Player:
    return e[0]


# In[9]:


e = (Player.one,17)
p = player(e)
p


# De même, écrire la fonction `quantity(e: tuple[Player, int])->int` qui renvoie le nombre d'allumettes du tas.

# In[10]:


#***************
def quantity(e: tuple[Player, int])->int:
    return e[1]


# In[11]:


e = (Player.one,17)
nb = quantity(e)
print("{}".format(nb))


# ### Q3
# 
# Ecrire la fonction `terminal(e: tuple[Player, int])->bool` qui indique si un état est terminal. 

# In[12]:


#***********
def terminal(e: tuple[Player, int]):
    return e[1]==0


# In[13]:


e = (Player.one,17)
terminal(e)


# In[14]:


e = (Player.two,0)
terminal(e)


# ### Q4
# 
# De même, écrire une fonction `authorized(e: tuple[Player, int])->bool` qui indique si un état est possible (nombre d'allumettes positif par exemple)

# In[15]:


#***********

def authorized(e: tuple[Player, int])->bool:
    test1 = 0<=quantity(e)<=init
    test2 = player(e)==Player.one \
        and quantity(e)!=init-1
    test3 = player(e)==Player.two \
        and quantity(e)!=init
    return test1 and (test2 or test3)


# In[16]:


authorized((Player.one,-1)),authorized((Player.two,17)),authorized((Player.one,init))


# On définit une exception qui sera soulevée par des fonctions n'acceptant que des états terminaux et auxquelles on communique un état qui ne l'est pas :

# In[17]:


class Not_Terminal(Exception):
    def __str__(self):
        return "Etat non terminal"
    


# ### Q5
# 
# Ecrire la fonction `outcome(e: tuple[Player, int])->Player` qui soulève une exception `Not_Terminal` si l'état `e` n'est pas terminal. Elle renvoie le joueur gagnant sinon.
# 
# Remarque : dans certains jeux, il existe des états de match nul. Dans ce cas, il faudrait adapter la fonction pour qu'elle renvoie `None` en cas de match nul. 

# In[18]:


#************
def outcome(e: tuple[Player, int])->Player:
    if not terminal(e): 
        raise Not_Terminal
    return other(player(e))


# In[19]:


e = (Player.two,0)
print(outcome(e))


# In[20]:


e = (Player.two,5)
try:
    print(outcome(e))
except Not_Terminal as nt:
    print(nt)


# ### Q6
# 
# Ecrire la fonction `move(e: tuple[Player, int]) -> list[tuple[Player, int]]` qui renvoie la liste des états voisins de l'état `e`, c.a.d les états qu'on peut joindre en un coup à partir de `e`.

# In[21]:


#*************
def move(e: tuple[Player, int]) -> list[tuple[Player, int]]:
    return [(other(player(e)),quantity(e)-i)\
            for i in range(1,N+1)\
            if \
            authorized((other(player(e)),
                        quantity(e)-i))]


# In[22]:


e = (Player.two,2)
etats = move(e)
for etat in etats:
    print("player:{},nb d'allumettes dans le tas = {}".format(player(etat).name,quantity(etat)))


# ### Q7
# 
# Ecrire la fonction `pred(e: tuple[Player, int]) -> list[tuple[Player, int]]` qui retourne la liste des états qui ont `e` comme voisin.

# In[23]:


#****************
def pred(e: tuple[Player, int]) -> list[tuple[Player, int]]:
    return [(other(player(e)),quantity(e)+i)
            for i in range(1,N+1) if\
            authorized((other(player(e)),\
                        quantity(e)+i))]


# In[24]:


e = (Player.one,init-2)
etats = pred(e)
for etat in etats:
    print("player:{},nb d'allumettes dans le tas = {}".format(player(etat).name,quantity(etat)))


# ### Q8
# 
# Ecrire la fonction `maj(j:Player,a:[tuple[Player, int]],d:dict)->[tuple[Player, int]]` qui correspond à une mise à jour de l'attracteur.
# 
# - `a` est la liste des états qui ont été ajoutés *au tour précédent* à l'attracteur;
# - `j` est le joueur dont on calcule l'attracteur;
# - `d` est un dictionnaire dont les clés sont des états et les valeurs sont quelconques. Si  l'état `e` est une clé de `d`, alors `e` est dans l'attracteur.
# 
# La fonction renvoie la liste des nouveaux états ajoutés à l'attracteur.

# In[25]:


#**********
def maj(j,a,d):
    if a==[]: return []
    new_a=[] # les nv e
    for s in a : 
        for v in pred(s):
            if player(v)\
            ==other(j)\
            and not v in d:
                convient = True
                for w in move(v):
                    if not w in d:
                        convient = False
                        break
                if convient:
                    new_a.append(v)
                    d[v]=True
            elif player(v)==j\
                 and not v in d: 
                    new_a.append(v)
                    d[v]=True
    return new_a


# In[26]:


e = (Player.two,0)
a = [e]
d = {e:True}
a=maj(Player.one,a,d)
for e in d :
    print(e)
print("-----------")
for e in a:
    print(e)

def attracteur(j):
    e = (other(j),0)
    d = {e:True}
    a = [e]
    while a!=[]:
        a = maj(j,a,d)
    return d

for e in attracteur(Player.one):
    print(e[0],e[1])

