#!/usr/bin/env python
# coding: utf-8

# # Solution naïve
# 
# 

# In[1]:


isinstance(2,int)


# In[2]:


# Q1.1
def some_element(d):
    for k in d:
        break
    return k
    
# Q1.2
def maxd(d):
    #d est un dictionnaire dont les clés sont des int
    m = some_element(d)
    for k in d:
        if k > m:
            m=k
    return m

# Q1.3
def check(C):
    d={}
    for cl in C:
        for c in cl:
            if not isinstance(c,int) or c<0 or c in d:
                return False
            else: d[c]=1
    m = maxd(d)
    for i in range(m+1):
        if i not in d:
            return False
    return True
   


# In[3]:


d = {1:6,3:2,15:-1,12:13}
some_element(d), maxd(d), check([[0 ,3] ,[1 ,5] ,[2 ,4]]), check([[0 ,3] ,[1 ,5] ,[6 ,4]])


# In[4]:


# Q2

"""
Dans le pire cas, on examine tous les éléments de tous les ensembles des partitions, soient 
O(n)
"""
def find_classe(x,C):
    for i in range(len(C)):# N passages
        if x in C[i]:#m passages au plus
            return C[i],i
    return [],-1
#complexité en O(n)


# In[5]:


# Q3
def en_relation(x,y,C):
    return y in find_classe(x,C)[0]
# complexité en O(n+m) = O(n)
"""
Il faut trouver la partition qui contient x en O(n)
puis examiner cette partition en O(m).

Cependant on remarque que m<= n

Donc complexité en O(n)
"""


C = [[0,3],[1,5],[2,4]]

print(find_classe(0,C)), print(find_classe(6,C))
en_relation(2,4,C), en_relation(0,1,C)
    


# In[6]:


# Q4.a O(|l1|+|l2|)
"""
C'est quasi le même algo que pour la fusion du tri fusion
"""
def fusion(l1,l2):
    i,j = 0,0
    r=[]
    while i < len(l1) and j < len(l2):
        if l1[i] == l2[j]:
            r.append(l1[i])
            i,j=i+1,j+1
        elif l1[i] < l2[j]:
            r.append(l1[i])
            i+=1
        else :
            r.append(l2[j])
            j+=1
    return r + l1[i:] + l2[j:]


# In[10]:


l1 = [10,15,20,30]
l2 = [5,15,17,19,20,26,28,30]
fusion(l1,l2)


# In[8]:


# Q4.b O(nN+nN+2n+N)=O(nN+n+N)
def union(x,y,C):
    l1,i = find_classe(x,C)#O(n)
    l2,j = find_classe(y,C)
    if i==j:
        return C
    l = fusion(l1,l2)#O(2m)
    i,j=min(i,j),max(i,j)
    return C[:i]+C[i+1:j]+C[j+1:]+[l]# O(N)


# In[9]:


C = [[0,3,7],[1,5,6],[2,4]]
union(3,5,C)


# # Union-find

# In[10]:


C = [5,3,4,3,4,3,4,5]


# In[11]:


#Q5
def create(n):
    return [i for i in range(n)]

create(7)


# In[12]:


# Q6
def find(i,C):
    if C[i]==i:
        return i
    return find(C[i],C)

C = [5,3,4,3,4,3,4,5,7]
find(3,C), find(7,C)


# In[13]:


# Q7
def union(x,y,C):
    i = find(x,C)
    j = find(y,C)
    if i>j:
        C[j]=i
    else:
        C[i]=j


# In[14]:


C = [5,3,4,3,4,3,4,5]
union(7,6,C)
C


# In[15]:


# Q8
def chaine(n):
    C = create(n)
    #print(C)
    for i in range(n-1):
        union(i,i+1,C)
        #print(C)
    return C

chaine(4)


# ## Première amélioration

# In[16]:


d = {"link":[5,3,4,3,4,3,4,5], "rank":[10,5,40,2,1,7,14,12]}
d


# In[17]:


#Q9
def create(n):
    C = [i for i in range(n)]
    R = [0]*n
    return {"link":C,"rank":R}

create(8)


# In[18]:


#Q10
def find(i,d):
    C = d["link"]
    def _find(i):
        if C[i]==i:
            return i
        return _find(C[i])
    return _find(i)

C = [5,3,4,3,4,3,4,5,7]
R = [100, 100, 100, 3, 1, 100, 100, 100]
d= {"link":C,"rank":R}
find(3,d), find(7,d)


# In[19]:


#Q15
C = [5,3,4,3,4,3,4,5,7]
R = [100, 100, 100, 3, 1, 100, 100, 100]
d= {"link":C,"rank":R}
def union(x,y,d):
    rx, ry = find(x,d), find(y,d)
    if rx!=ry:# sinon : rien à faire !
        Rx, Ry =  d["rank"][rx], d["rank"][ry]
        if Rx<Ry:
            d["link"][rx]=ry
        elif Rx>Ry:
            d["link"][ry]=rx
        else:
            d["link"][ry]=rx
            d["rank"][rx]=Rx+1                


# In[20]:


C = [5,3,4,3,4,3,4,5]
R = [100, 100, 100, 2, 1, 100, 100]
d= {"link":C,"rank":R}
union(3,4,d)
d


# In[21]:


C=create(6)# C est la partition
print(C)
union(0,1,C)
print(C)
union(2,3,C)
print(C)
union(0,2,C)
print(C)
union(1,4,C)
print(C)    


# # seconde amélioration
# 

# In[22]:


#Q16
def find(i,d):
    C = d["link"]
    def _find(i):
        if C[i]==i:
            return i       
        r = _find(C[i])
        C[i]=r
        return r
    return _find(i)
"""
Q17 : pas besoin d'adapter le code de union à la compression
de chemin. Toutefois, puisque la fonction find a changé,
il faut RECHARGER le code
"""
def union(x,y,d):#même code
    rx, ry = find(x,d), find(y,d)
    if rx!=ry:# sinon : rien à faire !
        Rx, Ry =  d["rank"][rx], d["rank"][ry]
        if Rx<Ry:
            d["link"][rx]=ry
        elif Rx>Ry:
            d["link"][ry]=rx
        else:
            d["link"][ry]=rx
            d["rank"][rx]=Rx+1   


# In[23]:


d=create(6)
print(d)
union(0,1,d)
print(d)
union(2,3,d)
print(d)
union(0,2,d)
print(d)
find(3,d)
print(d)
union(1,4,d)
print(d)


# In[24]:


C = [5,3,4,3,4,3,4,5,7]
R = [100, 100, 100, 2, 1, 100, 100,100]
d= {"link":C,"rank":R}
print(find(8,d))
d


# # Kruskal

# 
# 
# L'algorithme prélève un sommet dans la pile à chaque tour. Or, la pile est finie. Donc au bout d'un moment, elle est vide. L'algorithme termine. 

# ### Q19
# 
# Dans le pire cas, l'algorithme vide complètement la pile. Il y a donc $p$ tours. Dépiler est en $O(1)$. Les opérations union-find sont en temps amorti constant $O(1)$. La boucles est donc en $O(p)$.
# 
# La construction initiale union-find est en $O(n)$.
# 
# S'il faut en plus trier la liste des arcs, cela coûte $O(p\log p)$.
# 
# On a donc un coût total en $O(n+p+p\log p)=O(n+p\log p)$ avec $n-1\leq p$

# In[25]:


from typing import List, TypeVar, Callable, Optional, Tuple
#Q23
def llv2k(g):
    d={}
    for i in range(len(g)):
        for w,v in g[i]:
            d[(w,min(i,v),max(i,v))]=None
    return {"n":6,"arcs":[k for k in d]}

g = [[(3,1),(5,2)],[(3,0)],[(5,0),(10,3)],[(10,2)]]
print(llv2k(g))
g = [[(2,2),(1,1)],
     [(1,0),(3,2),(3,3)],
     [(2,0),(3,1),(4,3),(6,4)],
     [(3,1),(4,2),(4,4),(5,5)],
     [(6,2),(4,3),(2,5)],
     [(5,3),(2,4)]
    ]
print(llv2k(g))


# In[26]:


g = {"n":6,"arcs":[(2,0,2),(6,2,4),(2,4,5),(3,1,2),(4,2,3),\
                   (4,4,3),(1,0,1),(3,1,3),(5,3,5)]}


# In[27]:


from typing import List, TypeVar, Callable, Optional

T = TypeVar("T")
#déjà vue plus haut
def fusion(gauche: List[T], droite: List[T],
           key: Optional[Callable[[T], object]] = None) -> List[T]:
    """
    Fusionne deux listes déjà triées (gauche et droite) en une nouvelle liste triée.
    Stable: à clé égale, l'ordre relatif est conservé.
    """
    if key is None:
        key = lambda x: x  # type: ignore

    i, j = 0, 0
    res: List[T] = []
    while i < len(gauche) and j < len(droite):
        # stabilité: <= pour garder l'élément de gauche en premier en cas d'égalité
        if key(gauche[i]) <= key(droite[j]):
            res.append(gauche[i]); i += 1
        else:
            res.append(droite[j]); j += 1

    # Il reste au plus une des deux listes non vide
    if i < len(gauche):
        res.extend(gauche[i:])
    if j < len(droite):
        res.extend(droite[j:])
    return res

#Q24
def tri_fusion(tab: List[T], key: Optional[Callable[[T], object]] = None) -> List[T]:
    """
    Retourne une nouvelle liste triée par tri fusion (O(n log n) temps, O(n) mémoire).
    Ne modifie pas la liste d'entrée.
    """
    n = len(tab)
    if n <= 1:
        return tab[:]  # copie pour cohérence

    milieu = n // 2
    gauche = tri_fusion(tab[:milieu], key=key)
    droite = tri_fusion(tab[milieu:], key=key)
    return fusion(gauche, droite, key=key)




# In[28]:


#Q25
def kruskal(g):
    arcs = g["arcs"][:]
    n=g["n"]
    arcs = tri_fusion(arcs)#arcs.sort(key=lambda t:-t[0])#trier par ordre décroissant de poids
    U = create(n)
    T = []
    while (len(T))<n-1:
        w,x,y=arcs.pop()
        rx,ry=find(x,U),find(y,U)
        if rx!=ry:
            T.append((w,x,y))
            union(x,y,U)
    return {"n":n,"arcs":T}


# In[29]:


g = {"n":6,"arcs":[(2,0,2),(6,2,4),(2,4,5),(3,1,2),(4,2,3),\
                   (4,4,3),(1,0,1),(3,1,3),(5,3,5)]}
kruskal(g)


# In[30]:


# Q26
def poids(g):
    return sum(t[0] for t in g["arcs"])


# In[31]:


tree = kruskal(g)
poids(tree)


# # Application
# 
# 

# In[32]:


arcs = [(5,0,1),(18,0,2),(9,0,3),(13,0,4),(7,0,5),(38,0,6),(22,0,7),\
       (17,1,2),(11,1,3),(7,1,4),(12,1,5),(38,1,6),(5,1,7),\
       (27,2,3),(23,2,4),(15,2,5),(20,2,6),(25,2,7),\
       (20,3,4),(15,3,5),(40,3,6),(25,3,7),\
       (15,4,5),(40,4,6),(30,4,7),\
       (35,5,6),(10,5,7),\
       (45,6,7)]   

g={"n":8,"arcs":arcs}
g                                                           


# In[33]:


tree=kruskal(g)
tree


# In[34]:


poids(tree)


# In[ ]:




