def traiter(ligne, dico):#traitement d'une ligne
    key, notes_partie = ligne.split(":")
    # ex:"Dupont Jean"
    notes_str = notes_partie.split()
    # ex : ["12", "10", "_", "7"]
    key=" ".join(key.split())
    #suppression des espaces inutiles
    liste_notes = []
    for s in notes_str:
        if s == "_":liste_notes.append(None)
        elif s == "": #["12", "10", "_","",  "7"]
            pass # ne rien faire
        else: liste_notes.append(float(s))
    dico[key] = liste_notes

def notes(nom_de_fichier: str) -> dict:
    carnet = {}
    with open(nom_de_fichier,'r') as f:
        lignes = f.readlines()#toutes les lignes
    #if not lignes:raise ValueError("Fich vide.")
    # --- Lignes des élèves ---
    for ligne in lignes:
        traiter(ligne,carnet)
    return carnet


def notes(nom_de_fichier: str) -> dict:
    carnet = {}
    f =  open(nom_de_fichier,'r')
    lignes = f.readlines()
    f.close()
    for ligne in lignes:
        traiter(ligne,carnet)
    return carnet


def _check(carnet_de_note: dict, nom_eleve: str)->None:
    """
    Lève une ValueError si l'élève n'existe pas ou 
    si tous ses devoirs sont absents.
    """
    if "Coefficients" not in carnet_de_note:
        raise ValueError("Le dictionnaire ne contient pas de coefficients (clé 'Coefficients').")
    
    if nom_eleve not in carnet_de_note:
        raise ValueError(f"Élève inconnu : {nom_eleve}")
    
    Coefficients = carnet_de_note["Coefficients"]
    notes_eleve = carnet_de_note[nom_eleve]
    
    if len(Coefficients) != len(notes_eleve):
        raise ValueError("Nombre de notes différent du nombre de coefficients.")

    if len([None for c in Coefficients if c is None]) == len(Coefficients):
        raise ValueError(f"Aucune note présente pour l'élève {nom_eleve}.")

def moyenne_eleve(carnet_de_note: dict, nom_eleve: str) -> float:
    """
    Renvoie la moyenne pondérée de l'élève, en ignorant les absences
    (None).
    """
    _check(carnet_de_note,nom_eleve)#programmation défensive : pas demandé en prépa
    #l'élève existe, a au moins une note, le dico contient une clé coefficients
    
    total_points = 0.0
    total_Coefficients = 0.0

    Coefficients = carnet_de_note["Coefficients"]
    notes_eleve = carnet_de_note[nom_eleve]
    
    for note, coef in zip(notes_eleve, Coefficients):
        if note is not None:
            total_points += note * coef
            total_Coefficients += coef        
    
    return total_points / total_Coefficients

def moyenne_eleve(carnet_de_note: dict, nom_eleve: str)-> float:
    """l'élève existe, a au moins une note,
    le dico contient une clé coefficients"""
    total_points = 0.0
    total_Coefficients = 0.0
    Coefficients = carnet_de_note["Coefficients"]
    notes_eleve = carnet_de_note[nom_eleve]
    for i in range(len(Coefficients)):#sans utiliser zip
        if notes_eleve[i] is not None:
            total_points += notes_eleve[i] * Coefficients[i]
            total_Coefficients += Coefficients[i]        
    return total_points / total_Coefficients



def moyenne_classe(carnet_de_note: dict) -> float:
    """
    Renvoie la moyenne de la classe : moyenne des moyennes des élèves.
    Si un élève n'a aucune note (que des absences), il est ignoré.
    """
    moyennes = []
    for nom in carnet_de_note:
        if nom == "Coefficients":
            continue  # on saute les coefficients
        try:
            m = moyenne_eleve(carnet_de_note, nom)
            moyennes.append(m)
        except ValueError:#programmation défensive
            # Élève sans notes valides -> on l'ignore
            pass
    if not moyennes:
        raise ValueError("Aucune moyenne d'élève calculable.")
    
    return sum(moyennes) / len(moyennes)


def moyenne_classe(carnet_de_note: dict) -> float:
    """
    Renvoie la moyenne de la classe : moyenne des moyennes
    des élèves.
    """
    moyennes = []
    for nom in carnet_de_note:
        if nom == "Coefficients":
            continue  # on saute les coefficients
        m = moyenne_eleve(carnet_de_note, nom)
        moyennes.append(m)#on suppose que tout est     
    return sum(moyennes) / len(moyennes)

def bilan_eleve(carnet_de_note: dict,
                nom_eleve: str,
                nom_fichier: str,
                commentaire: str) -> None:
    """
    Écrit dans un fichier un bilan pour un élève :
    - nom, prénom
    - ses notes (avec '_' pour les absences)
    - la liste des coefficients
    - sa moyenne
    - un commentaire du professeur
    """
    
    Coefficients = carnet_de_note["Coefficients"]
    notes_eleve = carnet_de_note[nom_eleve]
    
    # Calcul de la moyenne; peut soulever ValueError
    moyenne = moyenne_eleve(carnet_de_note, nom_eleve)
    
    # Préparation des chaînes à écrire
    notes_str = [
        "_" if note is None else f"{note:.2f}"
        for note in notes_eleve
    ]
    Coefficients_str = [str(c) for c in Coefficients]
    
    with open(nom_fichier, "w", encoding="utf-8") as f:
        f.write(f"Bilan de : {nom_eleve}\n")
        f.write("\n")
        f.write("Notes       : " + "  ".join(notes_str) + "\n")
        f.write("Coefficients: " + "  ".join(Coefficients_str) + "\n")
        f.write(f"Moyenne     : {moyenne:.2f}\n")
        f.write("\n")
        f.write("Commentaire du professeur :\n")
        f.write(commentaire + "\n")


def bilan_eleve(carnet_de_note: dict, nom_eleve: str,
                nom_fichier: str,commentaire: str) -> None:    
    Coefficients = carnet_de_note["Coefficients"]
    notes_eleve = carnet_de_note[nom_eleve]
    moyenne = moyenne_eleve(carnet_de_note, nom_eleve)
    #notes_str = ["_" if note is None else f"{note:.2f}"for note in notes_eleve ]
    notes_str = []
    for note in notes_eleve:
        if note is None:
            notes_str.append("_")
        else: 
            notes_str.append(str(note))
    Coefficients_str = [str(c) for c in Coefficients]
    with open(nom_fichier, "w", encoding="utf-8") as f:
        f.write(f"Bilan de : {nom_eleve}\n")
        f.write("\n")
        f.write("Notes   : " + " ".join(notes_str) + "\n")
        f.write("Coefficients: " +\
                " ".join(Coefficients_str) + "\n")
        f.write(f"Moyenne     : {moyenne:.2f}\n")
        f.write("\n")
        f.write("Commentaire du professeur :\n")
        f.write(commentaire + "\n")



if __name__ == "__main__":
    # 1) Lecture du fichier
    carnet = notes("notes.txt")
    print("Carnet lu :")
    print(carnet)
    print()
    
    # 2) Moyenne d'un élève
    mj = moyenne_eleve(carnet, "Dupont Jean")
    mp = moyenne_eleve(carnet, "Exbrayat Patrick")
    print(f"Moyenne de Dupont Jean       : {mj:.2f}")
    print(f"Moyenne de Exbrayat Patrick  : {mp:.2f}")
    
    # 3) Moyenne de la classe
    mc = moyenne_classe(carnet)
    print(f"Moyenne de la classe         : {mc:.2f}")
    
    # 4) Bilan de l'élève dans un fichier
    bilan_eleve(
        carnet_de_note=carnet,
        nom_eleve="Exbrayat Patrick",
        nom_fichier="bilan_exbrayat.txt",
        commentaire="Travail sérieux. Attention aux absences."
    )
    print("\nBilan écrit dans 'bilan_exbrayat.txt'.")
        
