#!/usr/bin/env python
# coding: utf-8

# In[14]:


l = [10,20,30,40]


# In[15]:


print(l[:2])#positions 0 et 1
print(l[2:])# positions 2 et 3
print(l[1:3])# positions 1 et 2


# La commande `liste[n:p]` est de complexité $O(p-n)$ car on reconstruit une nouvelle liste.

# In[16]:


l[-1], l[len(l)-1]#dernier élément


# # Placement

# ## Principe du placement
# 
# On considère la liste $10,20,30,40,15\dots$ et on veut placer l'elément 15 (position 4) à sa bonne place sachant que tout ce qui est à gauche est trié. On garde 15 en mémoire.
# 
# - on compare 15 avec l'élément en position $i-1$. On a $40>15$, donc on duplique 40 : la liste devient $10,20,30,40,40,...$ (15 a disparu)
# - on compare 15 avec l'élément en position $i-2$. On a$30>15$, donc on duplique 30 : la liste devient $10,20,30,30,40,...$  
# - on compare 15 avec l'élément en position $i-3$. On a$20>15$, donc on duplique 20 : la liste devient $10,20,20,30,40,...$
#   
# - on compare 15 avec l'élément en position $i-4$. On a $10\leq{}15$. Il faut sortir de la boucle.
# 
# La liste est $10,20,20,30,40,\dots$ 
# 
# On met 15 en position $(i-4)+1$
# 
# On obtient $10,15,20,30,40,\dots$

# In[9]:


def placer(l,i):
    t, j=l[i], i-1
    while j>=0 and l[j]>t:
        l[j+1]=l[j]#une seule écriture dans l !!
        j-=1 # en gros 4 opérations dans la boucl
    l[j+1] = t

l = [10,20,30,40,15,2,100,0]
placer(l,4)
print(l)


# Complexité de l'appel `placer(l,i)`.
# 
# - Meilleur cas : si `l[i]>=l[i-1]`, aucun passage dans la boucle. Cpx $O(1)$ (coût constant)
# - Pire cas : si `l[i]` est plus petit que tous les éléments à sa gauche. Il y a $i$ passages dans la boucle. Cpx $O(i)$

# In[10]:


def placer2(l,i):
    t, j=l[i], i-1
    while j>=0 and l[j]>l[j+1]:
        temp = l[j+1]
        l[j+1]=l[j]# 2 écritures dans l sans compter temp
        l[j] = temp
        j-=1

l = [10,20,30,40,15,2,100,0]
placer2(l,4)
print(l)
