
def transpose(m: Matrix) -> Matrix:
    if not m:#programation défensive
        return []# pas à apprendre si
                 #vs avez des difficultés
    n, p = len(m), len(m[0])
    t = create(p,n)
    for i in range(n):
        for j in range(p):
            t[j][i] = m[i][j]
    return t


def prod(m1, m2):
    n, p1 = len(m1), len(m1[0])#O(1)
    p2, m = len(m2), len(m2[0])#O(1)
    assert p1 == p2, "t ouf ou koa?"#O(1)
    res = create(n,m)#O(n * m)
    for i in range(n):
        for k in range(p1):
            for j in range(m):
                res[i][j] += \
                   m1[i][k]*m2[k][j]#O(1)
    return res
"""

Il y a $n \times p_1 \times m$ passage ligne 9 (qui est en $O(1)$)

Hors boucle les opérations sont en $O(1)$.

Donc complexité cubique en 
$$
O(n^1  p_1^1   m^1)
$$

Complexité spatiale :
en plus des variables p1,m,p2,n il faut
stocker la matrice résultat res de taille
$n \times m$

Donc cpx spatiale $O(n \times m)$ quadratique
"""

def passe(t,i):
    #i : position à laquelle on s'arrête
    swap = False
    for k in range(i-1):
        if t[k]>t[k+1]:
            swap = True
            prov = t[k+1]
            t[k+1]=t[k]
            t[k] = prov
    return swap
""" 
Pas de meilleur cas pour la complexite : on parcourt TOUJOURS la liste
jusqu'à la position i-1

le corps de boucle est en O(1).
Il y a i-1 passages.

Donc cpx (au pire et au meilleur) en
O(i)

"""

def passe(t,i):
    #i : position à laquelle on s'arrête
    swap = False
    for k in range(i-1):
        if t[k]>t[k+1]:
            swap = True
            t[k], t[k+1] = t[k+1], t[k]
            #sucre syntaxique
    return swap
    
def bulle(t:list)->None:
    i=len(t)
    while passe(t,i):
        i-=1


"""
On passe AU MOINS une fois dans la
boucle.

Si aucun échange n'est réalisé, alors
on s'arrête et la complexité est  celle de `passe(t,len(t))` donc en $O(\vert t \vert)$. Ce meilleur cas se produit quand la liste est triée dans le bon ordre.

Le pire cas se produit quand la liste est triée dans le mauvais ordre. Il y a alors $\vert t \vert$ passages dans la boucle.

On appelle donc `passe(t,len(t))` puis `passe(t,len(t)-1)` puis `passe(t,len(t)-2)` etc.Chaque appel `passe(t,i)` coûte $O(i)$.

La cpx est proportionnelle à
$$
\sum_{i=1}^{n}i=\dfrac{n(n+1)}{2}=O(n^2)
$$

"""
