let l = [1;2;3];;

let l'= 15 :: l;;
l' = l,
l' == l;;

let l2 = [1;2;3] in
    l2 = l,
    l2 == l;;

l[1];;
l.(1);;

[1;2;3] = 1::2::3::[];;


let rec lg l =
  if l = [] then 0
  else (
    let a::q = l in
    1 + lg q
  );;

lg [], lg [1;2;3];;

List.tl [1;2;3],
List.hd [1;2;3];;

let rec lg l =
  if l = [] then 0
  else (
    let q =
      List.tl l in
    1 + lg q
  );;

let rec lg l =
  match l with
  | [] -> 0
  | x :: q -> 1
              +
                lg q;;

lg [], lg [1;2;3];;  

let rec add
      (l: int list):
      int =
  (*renvoie la somme
   des elts de l*)
  match l with
  | [] -> 0
  | x :: q -> x
              +
                add q;;

add [1;2;3];;

let rec copy
      (l: int list):
      int list =
  match l with
  | [] -> []
  | x :: q -> x
              ::
                (copy q);;

let l = [1;2;3] in
    let l' = copy l in l', l = l', l==l';;

let rev l =
  let rec aux envers l  =
    match l with
    | [] -> envers
    | x :: q -> aux (x::envers) q in
  aux [] l;;

rev [1;2;3];;

let rec emballer
      (l: int list):
      int list list =
  match l with
  | [] -> []
  | x :: q -> [x]
              ::
                (emballer q);;

emballer [1;2;3];;

let rec loop p f x =
  if p x then x
  else loop p f (f x);;

loop ( fun x -> x > 5) ( fun x -> x + 3) 1;;
loop ( fun x -> x > 5) ( fun x -> x + 3) 6;;

let sqrt x =
  assert (x >=0);
  (loop
     (fun y -> y*y >x)
     (fun y-> y+1) 0)
  - 1 ;;

sqrt 5, sqrt 4;;

let rec separer l =
  match l with
  | [] -> [], []
  | [x] -> [x], []
  | x::y::q ->
     let pair, impair = separer q in
     x::pair, y::impair;;

separer
  [1;2;3;4;5];;

separer
  [1;2;3;4];;

(*aux pair impair l
pair : liste elts pos paire rencontrés jusquici 
impair:liste elts pos impair rencontr. jusquici
l : liste qui reste à traiter
 *)
let separer l =
  let rec aux pair impair l =
      match l with
      | [] -> rev pair, rev impair
      | [x] -> rev (x::pair), rev impair 
      | x::y::q -> aux (x::pair) (y::impair) q
 in aux [] [] l;;

separer
  [1;2;3;4;5];;

separer
  [1;2;3;4];;


let separer l =
  let rec aux pair impair l =
      match l with
       [] -> rev pair, rev impair
      | x::q -> aux impair (x::pair) q
 in aux [] [] l;;

separer
  [1;2;3;4;5];;

separer
  [1;2;3;4];;

let rec exists p l =
  match l with
    [] -> false
  | x :: q ->
     if p x then true
     else exists p q;;
  
exists
  ( fun x -> x mod 2 = 1)
  [10;20;30];;


exists
  ( fun x -> x mod 2 = 1)
  [10;21;30];;


exists
  ( fun x -> x mod 2 = 1)
  [];;

let rec exists p l =
  match l with
    [] -> false
  | x :: q ->
     (p x) || exists p q;;
(*évaluation paresseuse
  on évalue exists p q
  uniquement si on n'a pas
  p x
 *)

let mem x l =
  exists (fun y -> y=x) l;;

mem 10 [1;2;3];;
mem 3 [1;2;3];;

let for_all p l =
  not
    (exists
       (fun x -> not (p x))
     l
    );;

for_all
  ( fun x -> x mod 2 = 1)
  [1;21;35];;

for_all
  ( fun x -> x mod 2 = 1)
  [115;21;30];;

for_all
  ( fun x -> x mod 2 = 1)
  [];;

let for_all p l =
  not @@
    exists
      (fun x -> not @@ p x)
      l    ;;

let rec insere x l =
  match l with
    [] -> [x]
  | y :: q ->
     if x > y then
       y :: (insere x q)
     else
       x :: l;;



insere 25 [10;20;30;40];;

insere 45 [10;20;30;40];;

insere 5 [10;20;30;40];;

(*Complexité

Meilleur cas
Si x < tous les elts de l
il n'y a pas d'appel
récursif. La cpx est un
O(1) 

Pire cas
x > tous les elts de l
posons n = |l|
l'équation de cpx est
C_n = C_{n-1} + O(1)
simplifié en
C_n = C_{n-1} + 1
Donc C_n =  C_0 + n
Alors C_n = O(n)
 *)

let rec tri_insertion l =
  match l with
    [] -> []
  | x :: q ->
     insere
       x
       (tri_insertion q);;

tri_insertion
  [5;0;8;3;6;7;10;1;8];;

(*Cpx

  Pire cas :

  n = |l|
  
  quand à chaque étape
  x doit être placé
  tout au bout de la
  version triée de q

  cela arrive quand la liste est triée dans l'ordre décroissant

  |tri_insertion q| = n-1
  insere x (tri_insertion q) est un O(n-1) c.a.d
  O(n)

  equation de cpx
  C_n = C_{n-1} + O(n)
  simplifié en
  C_n = C_{n-1} + n
  Alors
  C_n-C_{n-1} = n
  Par télescopage
  C_n-C_0 = sum_{1}^n k
  = n(n+1)/2=O(n^2)
  
 *)
