#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <assert.h>

typedef struct Element Maillon;
struct Element
{
  int val;
  Maillon *next;
};    

typedef struct Liste Liste;
struct Liste
{
    Maillon *first;
};

Liste *initialisation(int x)
{
    Liste *liste = malloc(sizeof(Liste));
    Maillon *maillon = malloc(sizeof(Maillon));

    if (liste == NULL || maillon == NULL)
        exit(EXIT_FAILURE);

    maillon->val = x;
    maillon->next = NULL;
    liste->first = maillon;

    return liste;
}

void ajouterDebut(Liste *liste, int x){
  //ajoute x en tête de liste
  Maillon *maillon =
    malloc(sizeof(Maillon));
  
  if (maillon == NULL)
        exit(EXIT_FAILURE);
  maillon->val = x;
  maillon->next = liste->first;
  liste->first = maillon; 
}


void afficheMaillons(Maillon *elt){
  printf("%d->",elt->val);// affiche 3
  if (elt->next == NULL)
    printf("NULL\n");
  else
    afficheMaillons(elt->next);
}

void afficheListe(Liste *liste){
  if (liste->first==NULL)
    printf("None\n");
  else
    afficheMaillons(liste->first);
}

Maillon *initMaillon(int x){
  /* crée un pointeur vers
     un Maillon de valeur x
     et dont le suivant est NULL
   */
  Liste *pl = initialisation(x);// une liste provisoire
  Maillon * pe = pl->first;
  free(pl);// libérer le pointeur sur la liste
  return pe;
}

Maillon * trouverDernier(Maillon * current){
  // retourne le dernier maillon d'une chaine
  assert(current!=NULL);// current doit pointer sur un vrai maillon
  if (current->next == NULL)
    return current;
  else
    return trouverDernier(current->next);
}

void ajouterFin(Liste *liste, int x){
  //ajoute x en queue de liste
  if (liste->first==NULL)
    ajouterDebut(liste,x);
  else{
  Maillon * last = trouverDernier(liste->first);// le dernier maillon
  Maillon * new = initMaillon(x);// le nouveau maillon
  last->next=new;// ajouter le nouveau maillon
  }
}


bool estVide(Liste * liste){
  return (bool) (liste->first==NULL);
}
