#ifndef TPLC_H
#define TPLC_H

#include <stdbool.h>

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>


#ifdef __cplusplus
extern "C" {
#endif



//-------------- COLORATION -----------
# define RED "\033[0;31m"
/*
\033[ : taille de police normale
*/
# define YELLOW "\033[1;33m"
# define RESET "\033[0m" 
# define SQUARE "\u25A0"
// ------------- FIN COLORATION ---------------

typedef struct Element Maillon;
typedef struct Liste Liste;

struct Element {
  int val;
  Maillon *next;
};

struct Liste {
  Maillon *first;
};

// Construction / modification
Liste *creation(void);
void ajouterDebut(Liste *liste, int x);
void ajouterFin(Liste *liste, int x);

// Affichage
void afficheListe(const Liste *liste);

// Libération
void liberer(Liste *liste);

// Utilitaires
bool estVide(const Liste *liste);
int length(const Liste *liste);
int length2(const Liste *liste);
Maillon *position(const Liste *liste, int p);
int supprimer(Liste *liste, int p);
int trouve(const Liste *liste, int v);
int trouve2(const Liste *liste, int v);

// Générateurs (pour tests/TP)
Liste *challenge(int n);
Liste *challenge2(int n);

#ifdef __cplusplus
}
#endif

#endif // TPLC_H
