#include "tplc.h"

static void test_ajoute_debut(void) {
  int t[4] = {1, 3, 7, 9};
  Liste *grip = creation();
  for (int i = 0; i < 4; i++)
    ajouterDebut(grip, t[i]);
  afficheListe(grip);
  liberer(grip);
}

static void test_ajoute_fin(void) {
  int t[4] = {1, 3, 7, 9};
  Liste *grip = creation();
  ajouterDebut(grip, 1);
  for (int i = 1; i < 4; i++)
    ajouterFin(grip, t[i]);
  afficheListe(grip);
  liberer(grip);
}

static void test_challenge2(void) {
  Liste *grip = challenge2(5);
  afficheListe(grip);
  liberer(grip);
}

static void test_length(void) {
  Liste *grip = challenge(5);
  afficheListe(grip);
  printf("length(grip)=%d\n", length(grip));
  liberer(grip);
}

static void test_length2(void) {
  Liste *grip = challenge(5);
  afficheListe(grip);
  printf("length(grip)=%d\n", length2(grip));
  liberer(grip);

  Liste *vide = creation();
  printf("length(vide())=%d\n", length2(vide));
  liberer(vide);
}

static void test_position(void) {
  Liste *grip = challenge2(5);
  afficheListe(grip);
  printf("position(grip,3)->val=%d\n", position(grip, 3)->val);
  liberer(grip);
}

static void test_supprimer(void) {
  Liste *grip = challenge(5);
  afficheListe(grip);
  printf("position(grip,3)->val=%d\n", position(grip, 3)->val);

  int val = supprimer(grip, 3);
  printf("valeur supprimées=%d\n", val);
  afficheListe(grip);

  val = supprimer(grip, 9);
  printf("valeur supprimées=%d\n", val);
  afficheListe(grip);

  val = supprimer(grip, 0);
  printf("valeur supprimées=%d\n", val);
  afficheListe(grip);

  liberer(grip);
}

int main(void) {
  // bench();
  test_ajoute_debut();
  test_ajoute_fin();
  test_challenge2();
  test_length();
  test_length2();
  test_position();
  test_supprimer();
  return EXIT_SUCCESS;
}
