#include "binarytree.h"

// Fonction de test pour les files
void testQueue() {
    Queue* queue = createQueue();
    Node* node1 = createNode(1);
    Node* node2 = createNode(2);
    Node* node3 = createNode(3);

    enqueue(queue, node1);
    enqueue(queue, node2);
    enqueue(queue, node3);

    printf("Test de la file:\n");
    while (!isEmpty(queue)) {
        Node* node = dequeue(queue);
        printf("%d ", node->data);
    }
    printf("\n");

    free(queue);
}

// Fonction de test pour les arbres binaires
void testBinaryTree() {
    Node* root = createNode(1);
    root->left = createNode(2);
    root->right = createNode(3);
    root->left->left = createNode(4);
    root->left->right = createNode(5);
    root->right->left = createNode(6);
    root->right->right = createNode(7);

    printf("Test de l'arbre binaire:\n");
    printf("Parcours infixe : ");
    inorder(root);
    printf("\n");

    printf("Parcours préfixe : ");
    preorder(root);
    printf("\n");

    printf("Parcours suffixe : ");
    postorder(root);
    printf("\n");

    printf("Parcours en largeur : ");
    breadthFirst(root);
    printf("\n");

    printf("Hauteur de l'arbre : %d\n", height(root));
    printf("Taille de l'arbre : %d\n", size(root));

    printf("Recherche de 7 : %s\n", find(root, 7) ? "Trouvé" : "Non trouvé");
    printf("Recherche de 25 : %s\n", find(root, 25) ? "Trouvé" : "Non trouvé");

    printf("Étiquette maximale : %d\n", max_label(root));

    deleteTree(root);
}

int main() {
    testQueue();
    testBinaryTree();
    return 0;
}
