#include "binarytree.h"

// Fonction pour créer une file vide
Queue* createQueue() {
    Queue* queue = (Queue*)malloc(sizeof(Queue));
    if (queue == NULL) {
        fprintf(stderr, "Erreur d'allocation mémoire\n");
        exit(EXIT_FAILURE);
    }
    queue->front = queue->rear = NULL;
    return queue;
}

// Fonction pour vérifier si la file est vide
int isEmpty(Queue* queue) {
    return queue->front == NULL;
}

// Fonction pour ajouter un élément à la file (enqueue)
void enqueue(Queue* queue, Node* data) {
    QueueNode* newNode = (QueueNode*)malloc(sizeof(QueueNode));
    if (newNode == NULL) {
        fprintf(stderr, "Erreur d'allocation mémoire\n");
        exit(EXIT_FAILURE);
    }
    newNode->data = data;
    newNode->next = NULL;

    if (isEmpty(queue)) {
        queue->front = queue->rear = newNode;
    } else {
        queue->rear->next = newNode;
        queue->rear = newNode;
    }
}

// Fonction pour retirer un élément de la file (dequeue)
Node* dequeue(Queue* queue) {
    if (isEmpty(queue)) {
        fprintf(stderr, "La file est vide\n");
        exit(EXIT_FAILURE);
    }
    QueueNode* temp = queue->front;
    Node* data = temp->data;
    queue->front = queue->front->next;

    if (queue->front == NULL) {
        queue->rear = NULL;
    }

    free(temp);
    return data;
}
