#ifndef BINARYTREE_H
#define BINARYTREE_H

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>

// Définition de la structure d'un nœud d'arbre binaire
typedef struct Node {
    int data;               // Donnée stockée dans le nœud
    struct Node* left;      // Pointeur vers le fils gauche
    struct Node* right;     // Pointeur vers le fils droit
} Node;

// Définition de la structure d'un nœud de la file
typedef struct QueueNode {
    struct Node* data;          // Pointeur vers un nœud d'arbre binaire
    struct QueueNode* next;     // Pointeur vers le nœud suivant
} QueueNode;

// Définition de la structure de la file
typedef struct {
    QueueNode* front;   // Pointeur vers l'avant de la file
    QueueNode* rear;    // Pointeur vers l'arrière de la file
} Queue;

// Fonctions pour les arbres binaires
Node* createNode(int data);
int height(Node* root);
int size(Node* root);
void deleteTree(Node* root);
void inorder(Node* root);
void preorder(Node* root);
void postorder(Node* root);
bool find(Node* root, int value);
int max_label(Node* root);
void breadthFirst(Node* root);

// Fonctions pour les files
Queue* createQueue();
int isEmpty(Queue* queue);
void enqueue(Queue* queue, Node* data);
Node* dequeue(Queue* queue);

#endif // BINARYTREE_H
