let rec factorielle n =
  match n with
    0 -> 1
  |  _ -> n * factorielle (n-1);;

factorielle 3;;

let rec facto n =
  let rec aux acc n =
    match n with
      0 -> acc
    | _ -> aux (n*acc) (n-1)
  in aux 1 n;;

facto 3;;

let long l = 
  let rec aux acc l = match l with
      [] -> acc
    | _::q -> aux (acc+1) q
  in aux 0 l;;

long [1;2;3];;

let rev list =
    let rec aux acc = function
      | [] -> acc
      | h :: t -> aux (h :: acc) t in
    aux [] list;;

let rec copy l = 
  match l with
      [] -> []
    | a::q -> a::(copy q);;

copy [1;2;3];;

let copy l = rev (rev l);;


let emballer l =
  let rec aux acc l = match l with
    | [] -> List.rev acc
    | x :: q -> aux ([x] :: acc) q
  in aux [] l;;

emballer [1;2;3];;

(* p : 'a -> bool et x : 'a
  int i = x;
  while (!p(i)){
     i = f(i);
   }
  return i 
 *)

let rec loop p f x =
  if p x then x
  else  loop p f (f x);;

loop ( fun x -> x > 5)
  ( fun x -> x + 3) 1;;

loop ( fun x -> x > 5)
  ( fun x -> x + 3) 6;;

let sqrt x =
  (*appeler loop*)
  loop
    (fun y -> y*y <= x)
    (fun y -> y-1)
    x;;

let sqrt x =
  (*appeler loop*)
  (loop
    (fun y -> y*y > x)
    (fun y -> y+1)
    0)-1;;



sqrt 4, sqrt 5;;

(*ne pas oublier rec !!*)
let  f x = if x<2 then x
          else f (x-1);; 



let separer l =
  let rec aux acc0 acc1 l =
    match l with
      [] -> List.rev acc0,
            List.rev acc1
    | [x] -> aux (x::acc0) acc1 []
    | x :: y :: q ->
       aux (x::acc0) (y::acc1) q
  in aux [] [] l;;

let rec separerBis l =
  let rec aux acc0 acc1 l =
    match l with
      [] -> List.rev acc0,
            List.rev acc1
    | x :: q ->
       aux acc1 (x::acc0) q
  in aux [] [] l;;


let rec exists p l =
  match l with
  | [] -> false
  | x :: q ->
     if p x then true
     else exists p q;;

separerBis [1;2;3;4;5];;

separerBis [5;4;3;2];;


separer [1;2;3;4;5];;

separer [5;4;3;2];;


let rec exists p l =
  match l with
  | [] -> false
  | x :: q -> if (p x) then true
              else exists p q;;

exists
  (fun x -> x<0)
  [1;2;-3;5];;

exists
  (fun x -> x<0)
  [1;2;3;5];;

let rec for_all p l =
  match l with
  | [] -> true
  | x :: q -> if p x then for_all p q
              else false;;

List.for_all (fun x -> x=2) [];;

(*neg \forall p
  equiv
  \exists neg p
 *)

let for_all p l =
  not @@
    exists (fun x -> not @@ p x)
      l;;


  

for_all (fun x -> x>2) [10;20;30];;
for_all (fun x -> x>2) [10;-20;30];;

let rec mem x l =
  match l with
  | [] -> false
  | y :: q -> if y = x then true else
                mem x q;;

let rec mem x l =
  match l with
  | [] -> false
  | y :: q when y=x->  true
  | _ :: q -> mem x q;;

let mem x l =
  exists (fun y -> y=x) l;;

mem 2 [1;2;3];;
(*hyp : l est triée croissant*)
let rec insere x l =
  match l with
  | [] -> [x]
  | y :: q when y<=x  ->
     y :: insere x q
  | _ -> x :: l;;

insere
  10
  [1;3;5;10;11];;

(*
Terminaison

les cas terminaux (1ere et 3eme règle de filtrage terminennt de façon évidente : pas de boucle et pas d'appel de fct).

dans la règle 2, il y a un appel interne à insere avec une liste
strictement plus courte que celle de l'appel externe : on a exibé un
VARIANT de récursion (c.a.d une quantité positive entière strictement
décroissante).

Terminaison OK

Complexité : les cas terminaux sont en
O(1).

Dans le meilleur des cas, on insere x au début (règle 3) et la cpxité est en O(1)

On note C(n) la cpxité de l'appel
"insere x l" pour "l" de taille "n".

Du fait de l'unique appel interne on a, dans le pire cas, une
récursion de la forme
C(n) = C(n-1) + O(1) simplifié en
C(n) = C(n-1) + 1

Cette relation est vérifiée à toutes les
étapes de la récursion ssi x est inséré
à la fin de la liste (pire cas).

Donc C(n) = C(0) + n*1 =O(1)+ O(n)=O(n)
 *)
  
