  //gcc -Wall matrices.c -lm
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>
#include <math.h>

/*--------------- AFFICHAGE ----------*/

void affiche(double t[], int n){//affiche un tableau
  for (int i=0; i<n; i++)
    printf("%f ",t[i]);
}//affiche

void affiche_mat(int n, int m,
		 double mat [n][m]){
  for (int i=0; i<n; i++){
    printf("| ");
    for (int j=0; j<m; j++){
      printf("%5.2f",mat[i][j]);
      if (j<m-1) printf(" ");// ? nécessaire?
    }//for j
    printf("|\n");
  }//for i
  printf("\n");
}

void affiche_mat_2(int n, int m, double mat [n][m]){
  for (int i=0; i<n; i++){
    printf("|");
    for (int j=0; j<m; j++){
      printf("%5.2f",mat[i][j]);
      if (j<m-1) printf(" ");
    }//for j
    printf("|\n");
  }//for i
  printf("\n");
}

void bench_affiche_mat(){
  double mat [2][2]={{1.,2.,},{3.,4.}};
  affiche_mat(2,2,mat);
}

void affiche_mat2(int n, int m, double mat [n][m]){
  for (int i=0; i<n; i++)
    affiche(mat[i],m);
}

void affiche_mat_while(int n, int m,
		 double mat [n][m]){
  int i=0;
  while (i<n){
    printf("| "); int j =0;
    while(j<m){
      printf("%5.2f ",mat[i][j]);
      j++;
    }//while j
    printf("|\n"); i++;
  }//while i
  printf("\n");
}

void bench_affiche_mat_while(){
  double mat [2][2]={{10.,20.,},
		     {3.,4.}};
  affiche_mat(2,2,mat);
}



/*--------- det --------------*/

double det(double mat[2][2]){
  return mat[0][0]*mat[1][1]
         -mat[1][0]*mat[0][1];
}

void bench_det(){
  double mat [2][2]={{1.,2.,},{3.,4.}};
  affiche_mat(2,2,mat);
  printf("det(mat)=%f\n", det(mat));
}


/*------- SOMME de matrices ----*/
void add(int n, int m,
	 double M1[n][m],
	 double M2[n][m],
	 double res[n][m]){
  for (int i=0; i<n; i++){
    for (int j=0; j<m; j++)
      res[i][j]=M1[i][j]+M2[i][j];
  }
}
/*
Complexité quadratique

 Double boucle.  Dans la boucle interne, 5 opération élémentaire
auxquelles on ajoute les incrémentations/comparaisons de compteur.

Complexité en O(n * m)

Calcul du nb d'additions :
Pour la ligne i :
  - m passage pour les colonnes
  - 2 additions par valeur de j (puisqu'il y a notamment i++) 
  Il faut y ajouter une add. pour i++

Total : \sigma_{i=0}^{n-1}(2m+1)=n(2m+1)  
*/




void bench_add(){
  double mat1 [2][3]={{1.,2.,3.},{4.,5.,6.}};
  double mat2 [2][3]={{1.,0.,-1.},{0.,-5.,-7.}};
  double res  [2][3];
  printf("mat1=\n");
  affiche_mat(2,3,mat1);
  printf("mat2=\n");
  affiche_mat(2,3,mat2);
  add(2,3,mat1,mat2,res);
  printf("add(2,3,mat1,mat2,res); res=\n");
  affiche_mat(2,3,res);
  
}


void prod(int n, double M1[n][n],
	  double M2[n][n],
	  double res[n][n]){
  for (int i=0; i<n; i++)
    for (int j=0; j<n; j++){
      res[i][j] = 0;// init du coef 
      for (int k=0; k<n; k++)
	 res[i][j] = res[i][j] +
	   M1[i][k]*M2[k][j];
    }
}// n^3 utilisation de *



void bench_prod(){
  double mat1 [3][3]={{1.,-1,2.},{2.,3.,1.},{-2,1.,-1}};
  double mat2 [3][3]={{0.,1.,-3.},{1.,-1.,1.},{-1,0.,1}};
  double res  [3][3];
  printf("mat1=\n");
  affiche_mat(3,3,mat1);
  printf("mat2=\n");
  affiche_mat(3,3,mat2);
  prod(3,mat1,mat2,res);
  printf("prod(3,mat1,mat2,res); res=\n");
  affiche_mat(3,3,res);
  
}


int main(){
  //bench_cl();
  //bench_affiche_mat();
  //bench_prod();
  bench_add();
  //bench_anti_transpose();
  //test_vects2mat();
  //test_solve();
  //test_vects2mat();
  //test_rotateV();
  //test_rotateA();
  //test_appartient();
  //test_ps();
  //test_pied();
  //test_sym();
  return 0;
}
