#include "tplc.h"

static void test_creation(){
  Liste * grip = creation();
  printf("creation() s'est bien passé !\n");
  free(grip);
}

static void test_ajoute_debut(void) {
  int t[4] = {1, 3, 7, 9};
  Liste *grip = creation();
  afficheListe(grip);
  for (int i = 0; i < 4; i++)
    ajouterDebut(grip, t[i]);
  printf("test_ajoute_debut : les ajouts sont ok\n");
  afficheListe(grip);
  liberer2(grip);//ou  liberer(grip);
}

static void test_ajoute_fin(void) {
  int t[4] = {1, 3, 7, 9};
  Liste *grip = creation();
  for (int i = 0; i < 4; i++)
    ajouterFin(grip, t[i]);
  afficheListe(grip);
  liberer(grip);
}

static void test_challenge(void) {
  Liste *grip = challenge(5);
  afficheListe(grip);
  liberer(grip);
  grip=challenge2(5);
  afficheListe(grip);
  liberer(grip);
}

static void test_est_vide(void){
  Liste * grip = creation();
  printf("estVide : %d\n", estVide(grip));
  ajouterDebut(grip, 0);
  printf("estVide : %d\n", estVide(grip));
  liberer(grip);
}


static void test_length(void) {
  Liste *grip = challenge(5);
  afficheListe(grip);
  printf("length(grip)=%d\n", length(grip));
  liberer(grip);
}
/*
static void test_length2(void) {
  Liste *grip = challenge(5);
  afficheListe(grip);
  printf("length(grip)=%d\n", length2(grip));
  liberer(grip);

  Liste *vide = creation();
  printf("length(vide())=%d\n", length2(vide));
  liberer(vide);
}
*/
static void test_position(void) {
  Liste *grip = challenge2(5);
  afficheListe(grip);
  printf("position(grip,3)->val=%d\n", position(grip, 3)->val);
  liberer(grip);
}

static void test_position2(void) {
  Liste *grip = challenge2(5);
  afficheListe(grip);
  printf("position2(grip,3)->val=%d\n", position2(grip, 3)->val);
  liberer(grip);
}



static void test_supprimer(void) {
  Liste *grip = challenge(5);
  afficheListe(grip);
  printf("position(grip,3)->val=%d\n", position(grip, 3)->val);

  int val = supprimer(grip, 3);
  printf("valeur supprimées=%d\n", val);
  afficheListe(grip);

  val = supprimer(grip, 9);
  printf("valeur supprimées=%d\n", val);
  afficheListe(grip);

  val = supprimer(grip, 0);
  printf("valeur supprimées=%d\n", val);
  afficheListe(grip);

  liberer(grip);
}

void test_trouve(){
  Liste *grip = challenge(5);
  afficheListe(grip);
  int x = 0;
  printf("position de %d : %d\n",
	 x,
	 trouve(grip,x)
	 );
  x = 10;
  printf("position de %d : %d\n",
	 x,
	 trouve(grip,x)
	 );
  liberer(grip);
}




static void test_pop(void) {
  Liste *grip = challenge(5);
  afficheListe(grip);
  printf("position(grip,0)->val=%d\n",
	 position(grip, 0)->val);

  int val = supprimer(grip, 0);
  printf("valeur supprimée par pop=%d\n", val);
  afficheListe(grip);

  liberer(grip);
}


int main(void) {
  // bench();
  test_creation();
  test_ajoute_debut();
  test_ajoute_fin();
  test_challenge();
  test_est_vide();
  test_length();
  //test_length2();
  test_position();
  test_position2();
  test_supprimer();
  test_trouve();
  test_pop();
  return EXIT_SUCCESS;
}
