#include <stdio.h>
#include <stdlib.h>

int main(void) {
    printf("Avant redirection : ceci va au terminal (stdout)\n");
    fprintf(stderr, "Avant redirection (erreur) : ceci va aussi au terminal (stderr)\n");

    // --- Redirections ---
    if (freopen("entree.txt", "r", stdin) == NULL) {
        perror("Impossible d'ouvrir entree.txt");
        return 1;
    }
    if (freopen("sortie.txt", "w", stdout) == NULL) {
        perror("Impossible d'ouvrir sortie.txt");
        return 1;
    }
    if (freopen("erreurs.txt", "w", stderr) == NULL) {
        perror("Impossible d'ouvrir erreurs.txt");
        return 1;
    }

    // --- Utilisation des flux redirigés ---
    char mot[100];
    if (scanf("%99s", mot) == 1) {
        printf("[stdout] Lecture réussie : mot = %s\n", mot);
        fprintf(stderr, "[stderr] Lecture correcte, aucune erreur détectée.\n");
    } else {
        fprintf(stderr, "[stderr] Erreur de lecture dans entree.txt\n");
    }

    // Fermeture des flux redirigés
    fclose(stdin);
    fclose(stdout);
    fclose(stderr);

    // --- Restauration vers le terminal ---

    freopen("/dev/tty", "r", stdin);
    freopen("/dev/tty", "w", stdout);
    freopen("/dev/tty", "w", stderr);


    // --- Affichage des résultats ---
    printf("\nAprès restauration :\n");
    printf("Lecture des fichiers générés...\n\n");

    FILE *f;

    // Contenu de sortie.txt
    printf("=== Contenu de sortie.txt ===\n");
    f = fopen("sortie.txt", "r");
    if (f) {
        int c;
        while ((c = fgetc(f)) != EOF)
            putchar(c);
        fclose(f);
    } else {
        perror("Lecture sortie.txt");
    }

    // Contenu de erreurs.txt
    printf("\n=== Contenu de erreurs.txt ===\n");
    f = fopen("erreurs.txt", "r");
    if (f) {
        int c;
        while ((c = fgetc(f)) != EOF)
            putchar(c);
        fclose(f);
    } else {
        perror("Lecture erreurs.txt");
    }

    printf("\n=== Fin du programme ===\n");

    return 0;
}
