#include <stdio.h>
#include <stdlib.h>

typedef struct {
  int nbl;
  int nbc;
  int **mat;
} matrix;

void dim(char *nom, int *nbl, int *nbc){
  FILE *f = fopen(nom, "r");
  fscanf(f, "%d", nbl);
  fscanf(f, "%d", nbc);
  fclose(f);
}


matrix* lecture(char *nom){
  FILE *f = fopen(nom, "r");
  int nbl, nbc;
  fscanf(f, "%d%d", &nbl,&nbc);
  matrix *m = malloc(sizeof(matrix));
  m->nbl = nbl;
  m->nbc = nbc;
  m->mat = malloc(nbl * sizeof (int*));
  for (int i = 0; i < nbl; ++i){
    m->mat[i] = malloc(nbc * sizeof(int));
  }
  for (int i = 0; i < nbl; ++i)
    for (int j = 0; j < nbc; ++j)
      fscanf(f, "%d", &m->mat[i][j]);
  fclose(f);
  return m;
}

/* Affiche la matrice (une ligne par ligne) */
void affiche(matrix *m){
  if (!m) return;
  for (int i = 0; i < m->nbl; ++i){
    for (int j = 0; j < m->nbc; ++j){
      if (j < m->nbc - 1) printf("%d ", m->mat[i][j]);
      else                printf("%d",   m->mat[i][j]);
    }
    printf("\n");
  }
}

void transpose(char *nom, matrix *m){
  FILE *g = fopen(nom, "w");
  /* entête de la transposée */
  fprintf(g, "%d\n", m->nbc);  /* nb de lignes */
  fprintf(g, "%d\n", m->nbl);  /* nb de colonnes */
  for (int j = 0; j < m->nbc; ++j){
    for (int i = 0; i < m->nbl; ++i){
      if (i < m->nbl - 1) fprintf(g, "%d ", m->mat[i][j]);
      else                fprintf(g, "%d\n", m->mat[i][j]);
    }
  }
  fclose(g);
}
void free_matrix(matrix *m){
  if (!m) return;
  for (int i = 0; i < m->nbl; ++i) free(m->mat[i]);
  free(m->mat);
  free(m);
}


int main(void){
  int nbl, nbc;
  dim("mat1.txt",&nbl,&nbc);
  printf("nbl=%d,nbc=%d\n",nbl,nbc);
  matrix * mat = lecture("mat1.txt");
  affiche(mat);
  transpose("mat1_T.txt",mat);
  free_matrix(mat);
  return 0;
}
