type 'a arbre = Nil | Node of ('a arbre * 'a * 'a arbre);;

let rec taille a =
  match a with
  | Nil ->0
  | Node(g,_,d)->
     1+taille g + taille d;;

let rec hauteur a =
  match a with
  | Nil -> -1
  | Node(g,_,d)->
     1+max
         (hauteur g)
         (hauteur d);;




let rec nbf a =
  match a with
  | Nil -> 0
  | Node (Nil, _, Nil) -> 1
  | Node (g,_,d) ->
     nbf g + nbf d;;

let rec nbi a =
  match a with
  | Nil | Node (Nil, _, Nil) -> 0
  | Node (g,_,d) ->
     1 + nbi g + nbi d;;

let nbi2 a = taille a - nbf a;;

let a = let b = Node (Nil, 1, Nil) and c = Node (Nil, 2, Nil)
      and d = Node (Nil, 3, Nil) in let g = Node (b,4,c) and f=
      Node (Nil, 5, Node(d,6,Nil)) in Node(g,7,f);;

let a = let b = Node (Nil, 1, Nil) and c = Node (Nil, 2, Nil)
            and d = Node (Nil, 3, Nil) in let g = Node (b,4,c) and f=Node (Nil, 5, Node(d,6,Nil)) in Node(g,7,f);;

nbf a, nbi a, nbi2 a;;

let applique f a =
  let rec aux acc a =
    match a with
    | Nil -> acc
    | Node(g,x,d)->
       aux (aux (f x acc) g) d
  in match a with
     | Nil | Node(Nil,_,Nil) ->
        failwith "NOK"
     | Node(g,x,d) ->
        aux (aux x g) d;;

applique max a,
applique min a,
applique (+) a,
applique ( * ) a;;


let rec miroir a =
  match a with
  | Nil -> Nil
  | Node(g,x,d)->
     Node(miroir d,
          x,
          miroir g);;

a;;
miroir a;;




type arith = Val of int
           | Plus of arith * arith
           | Mult of arith * arith
           | Minus of arith * arith
           | Div of arith * arith
           | Opp of arith;;

let a = let deux = Val 2
        and trois = Val 3 and
        six = Val 6 and
        quatre = Val 4 in
        Plus(Minus(six,quatre),
             Mult(
                 Plus(trois,deux),Opp deux));;

let rec eval (a:arith): int =
  match a with
    Val x -> x
  | Opp b -> - (eval b)
  | Plus (b,c) -> (eval b) + (eval c)
  | Minus (b,c) -> (eval b) - (eval c)
  | Div (b,c) -> (eval b) / (eval c)
  | Mult (b,c) -> (eval b) * (eval c);;

eval a;;

type 'a tree =
  F of 'a |
  N of 'a tree * 'a * 'a tree ;;

let rec height t =
  match t with
  | F _ -> 0
  | N(g,_,d) ->
     1 + max (height g) (height d);;

let rec size t =
  match t with
  | F _ -> 1
  | N(g,_,d) -> 1 + size g + size d;;

let rec strahler a =
  match a with
  | F _ -> 1
  | N (g,_,d)  ->
     let s1 = strahler g
     and s2 = strahler d in
     if s1 = s2 then s1 + 1 else
       max s1 s2;;

let tree1 =
  N(N(F 1,4,F 5),2,F 3);;

strahler tree1 ;;
let parfait3 = N(N(N(F 3,4,F 5),2,N(F 6,7, F 8)),1,N(N(F 10,11,F 12),9,N(F 13,14, F 15)));;

strahler parfait3;;


(*
  - renvoie la liste des étiquettes du chemin de la racine à x si
  il existe

  - renvoie [] sinon

 *)
let rec path a x = match a with
  | Nil -> []
  | Node(_,y,_) when y = x -> [x]
  | Node(g,y,d) ->
     let pl = path g x
     in if pl <> [] then y::pl
        else
          (let pr = path d x in
           if pr <> [] then y::pr else []) ;;

let a = let b = Node (Nil, 1, Nil) and c = Node (Nil, 2, Nil)
      and d = Node (Nil, 3, Nil) in let g = Node (b,4,c) and f=
      Node (Nil, 5, Node(d,6,Nil)) in Node(g,7,f);;
path a 6;;

path a 8;;


(*
  Rois :

  la fonction aux fait un parcours en profondeur

  elle gère une liste de descendants et la date de
  décès du roi courant

  on dépile un descendant
  - si ce déscendant est vivant après le
  décès du roi courant, alors il règne

  on poursuit le parcours en changeant
  la date de decès du roi courant.

  - si le descendant décède avant le roi courant,
  on poursuit le parcours

  
 *)
