#include "binarytree.h"


// Fonction pour créer un nouveau nœud
Node* createNode(int data) {
    Node* newNode = malloc(sizeof(Node));
    newNode->data = data;
    newNode->left = NULL;
    newNode->right = NULL;
    return newNode;
}
// Fonction pour calculer la hauteur de l'arbre
int height(Node* root) {
    if (root == NULL) {
        return -1; // La hauteur d'un arbre vide est -1
    }
    int leftHeight = height(root->left);
    int rightHeight = height(root->right);
    return 1 + (leftHeight > rightHeight ? leftHeight : rightHeight);
}

// Fonction pour calculer la taille de l'arbre (nombre de nœuds)
int size(Node* root) {
Node* createNode(int data) {
    Node* newNode = (Node*)malloc(sizeof(Node));
    if (newNode == NULL) {
        fprintf(stderr, "Erreur d'allocation mémoire\n");
        exit(EXIT_FAILURE);
    }
    newNode->data = data;
--
// Fonction pour calculer la taille de l'arbre (nombre de nœuds)
int size(Node* root) {
    if (root == NULL) {
        return 0; // La taille d'un arbre vide est 0
    }
    return 1 + size(root->left) + size(root->right);
}

// Fonction pour supprimer un arbre
void deleteTree(Node* root) {
    if (root == NULL) return;
// Fonction pour supprimer un arbre
void deleteTree(Node* root) {
    if (root == NULL) return;
    deleteTree(root->left);
    deleteTree(root->right);
    free(root);
}


// Parcours infixe (gauche -> racine -> droite)
void inorder(Node* root) {
    if (root == NULL) return;
    inorder(root->left);
    printf("%d ", root->data);
    inorder(root->right);
}
// Parcours préfixe (racine -> gauche -> droite)
void preorder(Node* root) {
    if (root == NULL) return;
    printf("%d ", root->data);
    preorder(root->left);
    preorder(root->right);
}

// Parcours suffixe (gauche -> droite -> racine)
void postorder(Node* root) {
    if (root == NULL) return;
    postorder(root->left);
    postorder(root->right);
    printf("%d ", root->data);
}

// Fonction pour rechercher une valeur dans l'arbre
bool find(Node* root, int value) {
    if (root == NULL) {
        return false;
	// L'arbre est vide ou l'étiquette n'a pas été trouvée
    }
    // Rechercher dans les sous-arbres gauche et droit
    return
      (root->data == value) ||
      find(root->left, value) ||
      find(root->right, value);
}

// Fonction pour trouver l'étiquette maximale de l'arbre
int max_label(Node* root) {
    assert(root != NULL); 
    int max = root->data; 
    // Comparer avec le sous-arbre gauche
    if (root->left != NULL) {
        int leftMax = max_label(root->left);
        if (leftMax > max) max = leftMax;
    }
    // Comparer avec le sous-arbre droit
    if (root->right != NULL) {
        int rightMax = max_label(root->right);
        if (rightMax > max) max = rightMax;
    }
    return max;
}

// Parcours en largeur (BFS)
void breadthFirst(Node* root) {
    if (root == NULL) return;
    // Créer une file et y ajouter la racine
    Queue* queue = createQueue();
    enqueue(queue, root);
    while (!isEmpty(queue)) {
        Node* currentNode = dequeue(queue);
        // Afficher la donnée du nœud
        printf("%d ", currentNode->data);
        if (currentNode->left != NULL) 
            enqueue(queue, currentNode->left);
        if (currentNode->right != NULL) 
            enqueue(queue, currentNode->right);
    }
    free(queue);
}
