#include "tplc.h"

Liste *creation(void){
  Liste* grip =
    malloc(sizeof(Liste));
  grip->first = NULL;
  return grip;
}

Maillon * initMaillon(int x){
  Maillon * m =
    malloc(sizeof(Maillon));
  m->val = x;
  m->next = NULL;
  return m;
}

void ajouterDebut(Liste *liste,
		  int x){
  Maillon * m = initMaillon(x);
  m->next = liste->first ;
  liste->first = m;
}

void afficheMaillons(Maillon *elt){
  if (elt == NULL)
    printf("%s\n",TRIANGLE);
  else{
    printf("%d%s->%s",elt->val,
	   RED,RESET);
    afficheMaillons(elt->next);
  }
}

void afficheListe(const Liste *liste){
  printf("%s%s->%s",SQUARE,YELLOW,RESET);
  afficheMaillons(liste->first);
}



void liberer_m(Maillon* m){
  // libérer tous les maillons
  if (m==NULL)    return;
  Maillon *next = m->next;
  free(m);
  liberer_m(next);//terminal
}

void liberer(Liste* g){
  // libère g et tous les maillons
  liberer_m(g->first);
  free(g);
}

void liberer2(Liste* g){
  // libère g et tous les maillons
  Maillon * ptrm = g->first;
  while (ptrm != NULL){
    Maillon * current = ptrm;
    ptrm = ptrm -> next;
    free(current);
  }
  free(g);
}


void ajouterFin(Liste * grip, int x){
  Maillon *maillon = initMaillon(x);
  Maillon * current = grip->first;
  if (current == NULL){
    grip->first = maillon;
    return;
  }
  while(current->next != NULL)
    current = current->next;
  current->next = maillon;
  }


Liste * challenge(int n){
  Liste *liste = creation();
  ajouterDebut(liste,0);
  for (int i=1; i<=n; i++){
    ajouterDebut(liste, i);
    ajouterFin(liste, i);
    // pb complexité !!
  }
  return liste;
}

Liste * challenge2(int n){
  //à préferer à la version 1 pour raison de cpx!
  Liste *liste =  creation();
  for (int i=-n; i<=n; i++){
    ajouterDebut(liste, abs(i));
  }
  return liste;
}


bool estVide(const Liste * liste){
  assert(liste!=NULL);
  return 
    liste->first==NULL;//O(1)
}

