#include "bibli.h"
#include "tp_struct.h"

void test_new_aws(){
  int n = 3;
  aws * a = new_aws(n);
  a->t[1]=5; a->t[2]=6;
  display_aws(a);
  free_aws(a);
}


void test_resize(){
  int n = 3;
  aws * a = new_aws(n);
  a->t[1]=5; a->t[2]=6;
  display_aws(a);
  resize(a,6);
  display_aws(a);
  free_aws(a);
}

void test_new_mws(){
  int n = 3, m=2;
  mws * M = new_mws(n,m);
   for (int i=0; i<M->nbl; i++)
     for (int j=0; j<M->nbc;
	  M->mat[i][j]=i*M->nbc+j,j++);
  display_mws(M);
  free_mws(M);
}

void test_hadamard(){
  int n = 3, m=3;
  mws * m1 = new_mws(n,m);
  mws * m2 = new_mws(n,m);
  mws * res = new_mws(n,m);

  m1->mat[0][0]=1;m1->mat[1][0]=1;
  m1->mat[02][0]=1;
  m1->mat[0][1]=3;m1->mat[0][2]=2;
  m1->mat[2][1]=2;m1->mat[2][2]=2;

  m2->mat[0][2]=2;m2->mat[1][0]=7;
  m2->mat[2][0]=2;m2->mat[1][1]=5;
  m2->mat[2][1]=1;m2->mat[2][2]=1;

  printf("matrice 1\n");
  display_mws(m1);

  printf("matrice 2\n");
  display_mws(m2);

  hadamard(m1,m2,res);
  printf("matrice res\n");
  display_mws(res);
  
  free_mws(m1); free_mws(m2);
  free_mws(res);
}





void test_randmatrix(){
  mws *M = randmatrix(3,4,10);
  display_mws(M);
  free_mws(M);
}


void test_commandline2matrix(int argc, char* argv[]){
  printf("test_commandline2matrix\n");
  if (argc!= 4){
      printf(BOLD RED "Rappels \n" RESET);
      printf(ITALIC YELLOW"En plus du nom de fichier," );
      printf(" il faut passer " UNDERLINE "3 arguments" RESET "\n");
      printf(GREEN "  - un nombre de lignes,\n" RESET);
      printf(GREEN "  - un nombre de colonnes,\n" RESET);
      printf(GREEN "  - une borne sup.\n" RESET);
      return;
	}
  //assert (argc == 4);
  int n = atoi(argv[1]);
  int m = atoi(argv[2]);
  int k = atoi(argv[3]);
  mws* M = randmatrix(n,m,k);
  display_mws(M);
  free_mws(M);
}

void test_assembleLignes(){
  aws * a1= new_aws(3);
  aws * a2= new_aws(3);
  a2->t[2]=3;  a1->t[0]=5;
  aws *t[2]= {a1,a2};
  mws * M = assembleLignes(2,t);
  display_mws(M);
  free_mws(M);
  free(a1);free(a2);
}

void test_assembleColonnes(){
  aws * a1= new_aws(3);
  aws * a2= new_aws(3);
  a2->t[2]=3;  a1->t[0]=5;
  aws *t[2]= {a1,a2};
  mws * M = assembleColonnes(2,t);
  display_mws(M);
  free_mws(M);
  free(a1);free(a2);
}

int main(int argc, char* argv[]){
  test_new_aws();
  //test_resize();
  //test_new_mws();
  //test_hadamard();
  //display_command_line(argc,argv);
  //test_randmatrix();
  //test_commandline2matrix(argc,argv);
  //test_assembleLignes();
  //test_assembleColonnes();
  return 0;
}
