
(* Somme des éléments d'une matrice d'entiers *)
let somme_matrice (m : int array array) : int =
  let s = ref 0 in
  for i = 0 to Array.length m - 1 do
    for j = 0 to Array.length m.(i) - 1 do
      s := !s + m.(i).(j)
    done
  done;
  !s;;


(* Somme de deux matrices d'entiers *)
let somme_deux_matrices (a : int array array) (b : int array array)
  : int array array =
  let nbl = Array.length a in
  let nbc = Array.length a.(0) in
  let c = Array.make_matrix nbl nbc 0 in
  for i = 0 to nbl - 1 do
    for j = 0 to nbc - 1 do
      c.(i).(j) <- a.(i).(j) + b.(i).(j)
    done
  done;
  c


exception Trouve;;
(*recherche v1*)
let contient_exn (x : int) (m : int array array) : bool =
  try
    for i = 0 to Array.length m - 1 do
      for j = 0 to Array.length m.(i) - 1 do
        if m.(i).(j) = x then raise Trouve
      done
    done;
    false
  with
  | Trouve -> true;;

(*recherche v2*)
let contient_while (x : int) (m : int array array) : bool =
  let nbl = Array.length m in
  if nbl = 0 then false
  else
    let nbc = Array.length m.(0) in
    let k = ref 0 in
    let trouve = ref false in
    while (!k < nbl * nbc) && not !trouve do
      let i = !k / nbc in
      let j = !k mod nbc in
      if m.(i).(j) = x then trouve := true;
      incr k
    done;
    !trouve;;
