#include "bibli.h"
#include "projet.h"

/* ===== Fonctions d'affichage print_one définie selon le type DATA ===== */
#if defined(DATA_IS_INT)
static void print_one(DATA x) { printf("%d", x); }
#elif defined(DATA_IS_FLOAT)
static void print_one(DATA x) { printf("%01.2f", x); }
#elif defined(DATA_IS_STRING)
static void print_one(DATA x) { printf("\"%s\"", x ? x : "(null)"); }
#else
/* fallback (au cas où -mais n'arrive pas dans ce projet-) : 
affiche l'adresse du "DATA" 
interprété comme pointeur */
static void print_one(DATA x) { printf("%p", (void*)x); }
#endif


/*
1.0f force le flottant à être de type float

par défaut 1.0 est de type double
*/
#if defined(DATA_IS_STRING)
#define V1 "one"
#define V2 "two"
#define V3 "three"
#elif defined(DATA_IS_FLOAT)
#define V1 1.0f
#define V2 2.0f
#define V3 3.0f
#else
#define V1 1
#define V2 2
#define V3 3
#endif
/*
1.0f -> cte de type float 
(ça pourraît être double avec 1.0)
*/


static void test_dlist_empty(void) {
  printf("test_dlist_empty DEBUT\n");
    dlist_t* l = dlist_empty();
    assert(l->size == 0);
    assert(l->head == NULL && l->tail == NULL);
    free(l);
    printf("test_dlist_empty FIN\n");
}

static void test_push_back_and_pop_back(void) {
    printf("test_push_back_and_pop_back DEBUT\n");
    dlist_t* l = dlist_empty();

    assert(dlist_push_back(l, V1));
    assert(dlist_push_back(l, V2));
    assert(l->size == 2);

    DATA x;
    assert(dlist_pop_back(l, &x));
    assert(l->size == 1);

    assert(dlist_pop_back(l, &x));
    assert(l->size == 0);

    assert(!dlist_pop_back(l, &x)); /* vide */
    free(l);
    printf("test_push_back_and_pop_back FIN\n");
}


static void test_push_front_and_pop_front(void) {
    printf("test_push_front_and_pop_front DEBUT\n");
    dlist_t* l = dlist_empty();

    assert(dlist_push_front(l, V1));
    assert(dlist_push_front(l, V2));
    assert(l->size == 2);

    DATA x;
    assert(dlist_pop_front(l, &x));
    assert(l->size == 1);

    assert(dlist_pop_front(l, &x));
    assert(l->size == 0);

    assert(!dlist_pop_front(l, &x)); /* vide */
    free(l);
    printf("test_push_front_and_pop_front FIN\n");
}


static void test_length(void) {
  printf("test_length DEB\n");
    dlist_t* l = dlist_empty();
    assert(dlist_length(l) == 0);
    dlist_push_back(l, V1);
    assert(dlist_length(l) == 1);
    dlist_clear(l);
    assert(dlist_length(l) == 0);
    printf("test_length FIN\n");
}

static void test_print(void) {
  printf("test_print DEB\n");
    dlist_t* l = dlist_empty();
    dlist_push_back(l, V1);
    dlist_push_back(l, V2);
    dlist_push_back(l, V3);
    dlist_print(l, print_one, ", ");
    printf("\n");
    dlist_clear(l);
    free(l);
    printf("test_print FIN\n");
}

static void test_stack(void) {
  printf("test_stack DEB\n");
    dlist_t* s = dlist_empty();

    assert(stack_push(s, V1));
    assert(stack_push(s, V2));
    printf("affichage de pile :");
    dlist_print(s, print_one, ", ");
    printf("\n");
    
    DATA x;
    assert(stack_pop(s, &x));
    printf("retiré de la pile : ");print_one(x);printf("\n");
    assert(stack_pop(s, &x));
    printf("retiré de la pile : ");print_one(x);printf("\n");
    assert(!stack_pop(s, &x));
    dlist_clear(s);
    free(s);
    printf("test_stack FIN\n");
}

static void test_queue(void) {
  printf("test_queue DEB\n");
    dlist_t* q = dlist_empty();

    assert(queue_enqueue(q, V1));
    assert(queue_enqueue(q, V2));
    printf("affichage de file :");
    dlist_print(q, print_one, ", ");
    printf("\n");
    DATA x;
    assert(queue_dequeue(q, &x));
    printf("retiré de la file : ");print_one(x);printf("\n");
    assert(queue_dequeue(q, &x));
    printf("retiré de la file : ");print_one(x);printf("\n");
    assert(!queue_dequeue(q, &x));
    dlist_clear(q);
    free(q);
    printf("test_queue FIN\n");
}

static void test_clear(void) {
    /*
      on ne peut pas vraiment tester la libération des maillons sans
      outil externe comme valrind
     */
  printf("test_clear DEB\n");
    dlist_t *l = dlist_empty();
    assert(l != NULL);

    for (int i = 0; i < 100; i++) {
        assert(dlist_push_back(l, V1));
    }
    assert(dlist_length(l) == 100);
    dlist_clear(l);
    assert(dlist_length(l) == 0);
    assert(l->head == NULL);
    assert(l->tail == NULL);
    free(l);
    printf("test_clear FIN\n");
}

int main(void) {
#if defined(DATA_IS_INT)
  printf("compilé avec make -DDATA=int\n\n");
#elif defined(DATA_IS_FLOAT)
  printf("compilé avec make -DDATA=float\n\n");
#elif defined(DATA_IS_STRING)
  printf("compilé avec make -DDATA=char*\n\n");
#endif
  
  test_dlist_empty();
  test_push_front_and_pop_front();
  test_push_back_and_pop_back();
  test_length();
  test_print();
  test_stack();
  test_queue();
  test_clear();

  printf("All tests passed.\n");
  return 0;
}
