#ifndef PROJET_H
#define PROJET_H

/* ===== Paramétrage du type DATA =====
   On peut le fixer à la compilation :
   gcc ... -DDATA=float
   gcc ... -DDATA=int
   gcc ... -DDATA='char*'
*/
#ifndef DATA
#define DATA int
#endif

/* Fonction d'affichage d'un élément */
typedef void (*print_data_fn)(DATA x);
/*un pointeur vers une fonction qui prend un DATA et ne renvoie rien*/


/* ===== Types ===== */
typedef struct node {
    struct node *prev;
    struct node *next;
    DATA data;
} node_t;

typedef struct dlist {
    node_t *head;
    node_t *tail;
    size_t  size;
} dlist_t;

/* ===== API "liste" (commun) ===== */
dlist_t* dlist_empty(void);

bool   dlist_push_front(dlist_t *l, DATA x);  /* ajout au début */
bool   dlist_push_back (dlist_t *l, DATA x);  /* ajout à la fin */

bool   dlist_pop_front(dlist_t *l, DATA *out); /* retrait au début  */
bool   dlist_pop_back (dlist_t *l, DATA *out); /* retrait à la fin  */

size_t dlist_length(const dlist_t *l);

void   dlist_clear(dlist_t *l); /* libère les maillons */
void   dlist_print(const dlist_t *l, print_data_fn print_one, const char *sep);

/* ===== API "pile" ===== */
bool stack_push(dlist_t *l, DATA x);      /* push = ajout au début */
bool stack_pop (dlist_t *l, DATA *out);   /* pop  = retrait au début */

/* ===== API "file" ===== */
bool queue_enqueue(dlist_t *l, DATA x);    /* enqueue = ajout à la fin */
bool queue_dequeue(dlist_t *l, DATA *out); /* dequeue = retrait au début */

#endif
