#ifndef ENTIERS_H
#define ENTIERS_H

#include <stdio.h>
#include <stdint.h>
#include <stddef.h>
#include <stdlib.h>
#include <inttypes.h>
#include <stdbool.h>
#include <assert.h>
#include <errno.h>
#include <string.h>

#define BIG_BITS 30
#define BIG_BASE       ((uint32_t) (1ULL << BIG_BITS))
#define DIGIT_MASK (BIG_BASE - 1U)

#define SIGN_NEG  ((int8_t)(-1))
#define SIGN_ZERO ((int8_t)(0))
#define SIGN_POS  ((int8_t)(+1))

typedef struct {
    int8_t sign;   // -1, 0, +1
    size_t       size;   // nb de digits utilisés (sans zéros de tête)
    size_t       cap;    // capacité allouée de d[]
    uint32_t    *d;      // digits little-endian, base 2^30 (d[0] = poids faible)
} bigint;

bigint *big_from_cstr(const char *s);
bigint *big_add_pos(const bigint *x, const bigint *y);
void sortie_python(const bigint *x, const char * filename);
void display(const bigint* x);//affichage base 2^{31}
void display10(const bigint* x);//affichage base 10 via python
void load(char *filename, char *x, char *y);
void free_ptr_bigint(bigint* x);
#endif

