#include <stdio.h>
#
#include <assert.h>
#include <time.h>
#include <stdlib.h>

/* Recherche dichotomique
   - v trié par ordre croissant
   - taille = n
   - retourne l'indice de x ou -1 si absent
*/
int search(int *v, int n, int x) {
    int left = 0, right = n;  /* intervalle [left, right) */
    while (left < right) {
        int mid = left + (right - left) / 2;
        if (v[mid] == x) return mid;
        else if (v[mid] < x)
            left = mid + 1;
        else
            right = mid;
    }
    return -1;
}
/*
Complexité au pire :

Notons floor(x) la partie entière par défaut d'un nombre x.

On a 2^{floor(log_2(n))}<=n<2^{floor(log_2(n))+1}.

On constate que hors boucle, le total des opérations est un O(1).

Le corps de boucle (test, affectations, opérations arithmétiques...)
est aussi un O(1).

La taille du sous-tableau exploré est divisée par 2 à chaque
étape. Donc en floor(log_2(n))+1 étapes on explore un tableau de taille

n / 2^{floor(log_2(n))+1} < 1. Donc ce tableau est de taille nulle. il
vient qu'alors left>=right et on sort de la boucle.

Résumons : 

- hors boucle, le total des opérations est un O(1) 

- Il y a au plus floor(log_2(n))+1 passages dans la boucle, chaque
passage étant un O(1).

La complexité de l'appel  search(int *v, int n, int x) est un
O(floor(\log_2n)+1) c.a.d. O(log_2(n)).

Complexité au mieux : 

Quand x est au milieu du tableau. O(1)

*/


int naive_search(int *v, int n, int x) {
    for (int i = 0; i < n; ++i) if (v[i] == x) return i;
    return -1;
}

int * tableau(int n){
  // renvoie un tableau de 10000 nombres
  
  int * p = malloc(n * sizeof(int));
  //rand non initialisé par srand :
  // c'est exprès, tjs la même séquence !
  for (int i=0; i<n; i++){
    int x = rand();
    if (x != 15000)
      p[i]=x;
  }
  return p;

}

/* ========== TEST ========== */
void test_search(void) {
    printf("== test_search (dichotomique) ==\n");
    int v[] = {1,3,5,7,9,11,15,20};
    int n = (int)(sizeof(v)/sizeof(v[0]));

    assert(search(v,n,1)  == 0);
    assert(search(v,n,7)  == 3);
    assert(search(v,n,20) == 7);

    /* valeurs absentes */
    assert(search(v,n,2)  == -1);
    assert(search(v,n,8)  == -1);
    assert(search(v,n,100)== -1);

    printf("OK\n\n");
}

void chrono1(){
  int n = 10000000;
  int *p=tableau(n);
  int x = 15000;//rand() retourne un nb entre 0 et RAND_MAX = 32767
  clock_t start,stop;
  double cpu_time_used;
  start = clock();//nb de ticks d'horloge depuis le début du pgm
  search(p, n, x);
  stop = clock();
  //CLOCKS_PER_SEC : nb de ticks par seconde
  cpu_time_used = ((double)(stop-start))/CLOCKS_PER_SEC;
  printf("durée recherche dichotomique %f s\n",cpu_time_used);

  start = clock();//nb de ticks d'horloge depuis le début du pgm
  naive_search(p, n, x);
  stop = clock();
  cpu_time_used = ((double)(stop-start))/CLOCKS_PER_SEC;
  printf("durée recherche naive        %f s\n",cpu_time_used);
  
  free(p);

}

int main(void) {
  //test_search();
  chrono1();
   return 0;
}
