#include "conv.h"

/* ------------------------- TESTS -----------------------------*/

void test_load_pgm(void){
  //seul argv[1] est exploité
  Image in = {0};
  //idem Image in = { .w = 0, .h = 0, .data = NULL };
  
  int rc = load_pgm("vache_et_veau.pgm", &in);
  assert(rc==0);//retour 0 est normal

  assert(in.w==433 && in.h == 250);
  printf("\%d;%d,%d\n",in.data[0],
	 in.data[10000],
	 in.data[80053]);
  assert(in.data[0]==182 &&
	 in.data[10000] == 191
	 && in.data[80053] == 98);

  free(in.data);
  printf("test_load_pgm OK\n");
}

void test_seuil(void){
  Image in = {0};
  //idem Image in = { .w = 0, .h = 0, .data = NULL };
  
  int rc = load_pgm("vache_et_veau.pgm", &in);
  assert(rc==0);//retour 0 est normal

  Image * outseuil =  seuil(&in);
  
  printf("%d;%d,%d\n",outseuil->data[0],
	 outseuil->data[8623],
	 outseuil->data[80053]);

  assert(outseuil->data[0] == 255 &&
	 outseuil->data[8623] == 0 &&
	 outseuil->data[80053] == 255);
  
  rc = save_pgm("vache_et_veau_seuil.pgm", outseuil);
  assert(rc==0);
  free(in.data);
  free(outseuil->data);
  free(outseuil);
  printf("test_seuil OK\n");
}


void test_sobel(void){
  Image in = {0};
  //idem Image in = { .w = 0, .h = 0, .data = NULL };
  
  int rc = load_pgm("vache_et_veau.pgm", &in);
  assert(rc==0);//retour 0 est normal
  
  Image * outsobel =   sobel_edges(&in);

  assert(outsobel->w==433 && outsobel->h == 250);
  
  printf("%d;%d,%d\n",outsobel->data[0],
	 outsobel->data[10000],
	 outsobel->data[80053]);

  assert(outsobel->data[0] == 255 &&
	 outsobel->data[10000] == 0 &&
	 outsobel->data[80053] == 0);
  
  rc = save_pgm("vache_et_veau_sobel.pgm", outsobel);
  assert(rc==0);
  free(in.data);
  free(outsobel->data);
  free(outsobel);
  printf("test_sobel OK\n");
}

void test_neg(void){
  Image in = {0};
  //idem Image in = { .w = 0, .h = 0, .data = NULL };

  int rc = load_pgm("vache_et_veau.pgm", &in);
  assert(rc==0);
  
  Image *  outneg = negative(&in);

  
  printf("in : %d;%d,%d\n",in.data[0],
	 in.data[10000],
	 in.data[80053]);
  
  printf("out : %d;%d,%d\n",outneg->data[0],
	 outneg->data[10000],
	 outneg->data[80053]);

  assert(outneg->data[0] == 73 &&
	 outneg->data[10000] == 64 &&
	 outneg->data[80053] == 157);
  
  rc = save_pgm("vache_et_veau_neg.pgm", outneg);
  assert(rc==0);

  
  free(in.data);
  free(outneg->data);
  free(outneg);

  printf("test_neg OK\n");
}

void test_convert_ppm2pgm(void){
  //passage de ppm (couleur) à pgm (niveau de gris)
  convert_ppm2pgm("chien_blanc.ppm",
		  "chien_blanc.pgm");

  printf("test_convert_ppm2pgm OK\n");
}

int main(int argc, char **argv) {

  test_load_pgm();
  test_neg();
  test_seuil();
  test_sobel();
  test_convert_ppm2pgm();  
  
}
