#ifndef CONV_H
#define CONV_H

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <assert.h>
//pour isdigit:
#include <ctype.h> 


// --- Constantes -------------------------------------------------------------

// Permet de surcharger au compile-time avec -DTHRESHOLD=...
#ifndef THRESHOLD
#define THRESHOLD 80
#endif

// --- Types ------------------------------------------------------------------

typedef struct {
    int w, h;
    uint8_t *data; // row-major: h lignes de w octets
} Image;

// --- API principale ---------------------------------------------------------

// Lecture/écriture PGM (binaire, P5 ; profondeur <= 255)
int load_pgm(const char *path, Image *img);
int save_pgm(const char *path, const Image *img);

// Conversion PPM (P6) -> PGM (P5) par luminance Rec.601
int convert_ppm2pgm(const char *source, const char *dest);

// Transformations d’images (renvoient une nouvelle Image* à libérer par l’appelant)
Image *negative(const Image *in);
Image *sobel_edges(const Image *in);
Image *seuil(const Image *src);

// --- Outils parsing PNM (avancés) ------------------------------------------
// Exposés si tu veux les réutiliser dans d’autres chargeurs.
// N.B. skip_ws_and_comments lit jusqu’au prochain token non-espace et non-commentaire.
void skip_ws_and_comments(FILE *f);
int  read_int(FILE *f);

#endif // CONV_H
